<?php

/**
 * PrestaShop module created by VEKIA, a guy from official PrestaShop community ;-)
 *
 * @author    VEKIA PL MILOSZ MYSZCZUK VATEU: PL9730945634
 * @copyright 2010-9999 VEKIA
 * @license   This program is not free software and you can't resell and redistribute it
 *
 * CONTACT WITH DEVELOPER http://mypresta.eu
 * support@mypresta.eu
 */

use PrestaShop\PrestaShop\Adapter\Image\ImageRetriever;
use PrestaShop\PrestaShop\Adapter\Product\PriceFormatter;
use PrestaShop\PrestaShop\Adapter\Presenter\Product\ProductListingPresenter;
use PrestaShop\PrestaShop\Adapter\Product\ProductColorsRetriever;

class relatedfree extends Module
{
    public $mkey;
    public $mypresta_link;
    public $secure_key;

    public function __construct()
    {
        $this->name = 'relatedfree';
        $this->tab = 'advertising_marketing';
        $this->author = 'MyPresta.eu';
        $this->mypresta_link = 'https://mypresta.eu/modules/front-office-features/related-products-free.html';
        $this->version = '1.7.0';
        $this->module_key = 'de6f0cf17c8cb0d314ec544203a9f5f5';
        $this->bootstrap = true;
        parent::__construct();
        $this->displayName = $this->l('Related products free');
        $this->description = $this->l('Module allows to display custom related products block with products from selected category');
        if (!($this instanceof relatedfreeUpdate)) {
            (new relatedfreeUpdate())->runUpdateSetUp();
        }
    }

    /**
     * PrestaShop version helper – compatible with 1.7, 8 and 9.
     * @param int $part 0=major, 1=minor, 2=patch, 3=extra
     * @return int|string
     */
    public static function psversion($part = 1)
    {
        $version = defined('_PS_VERSION_') ? _PS_VERSION_ : '0.0.0';
        $exp = explode('.', $version);
        if ($part == 0) {
            return isset($exp[0]) ? (int) $exp[0] : 0;
        }
        if ($part == 1) {
            if (isset($exp[0]) && (int) $exp[0] >= 8) {
                return 7;
            }
            return isset($exp[1]) ? (int) $exp[1] : 0;
        }
        if ($part == 2) {
            return isset($exp[2]) ? (int) $exp[2] : 0;
        }
        if ($part == 3) {
            return isset($exp[3]) ? $exp[3] : 0;
        }
        return 0;
    }

    public function hookactionAdminControllerSetMedia($params)
    {
        //for update feature purposes
    }

    public function return_rf_tpath()
    {
        $rf_tpath = Configuration::get('rf_tpath');
        if ($rf_tpath != '' && $rf_tpath != false) {
            return $rf_tpath;
        } else {
            return 'catalog/_partials/miniatures/product.tpl';
        }
    }

    public function checkforupdates($display_msg = 0, $form = 0)
    {
        return (new relatedfreeUpdate())->checkforupdates($display_msg, $form);
    }

    public function inconsistency()
    {
        return (new relatedfreeUpdate())->inconsistency();
    }

    public function getContent()
    {
        if (Tools::isSubmit('btnSubmit')){
            Configuration::updateValue('rf_tpath', Tools::getValue('rf_tpath', 'catalog/_partials/miniatures/product.tpl'));
            Configuration::updateValue('rf_maincss', Tools::getValue('rf_maincss', 'featured-products clearfix'));
            Configuration::updateValue('rf_productscss', Tools::getValue('rf_productscss', 'products row'));
            $this->context->controller->confirmations[] = $this->l('Settings saved');
        }
        return $this->renderForm().$this->checkforupdates(0, 1);
    }

    public function install()
    {
        if (parent::install() == false or
            !Configuration::updateValue('rf_tpath', 'catalog/_partials/miniatures/product.tpl') or
            !Configuration::updateValue('rf_maincss', 'featured-products clearfix') or
            !Configuration::updateValue('rf_productscss', 'products row') or
            !$this->registerHook('displayProductFooter') or
            !$this->registerHook('displayFooterProduct') or
            !$this->registerHook('displayAdminProductsExtra') or
            !$this->registerHook('actionProductUpdate'))
        {
            return false;
        }
        return true;
    }

    public function hookactionProductUpdate($params)
    {
        if (Tools::isSubmit('relatedfree'))
        {
            Configuration::updateValue('related_category' . Tools::getValue('id_product'), Tools::getValue('related_category'));
            Configuration::updateValue('related_nb' . Tools::getValue('id_product'), Tools::getValue('related_nb'));
            Configuration::updateValue('related_link' . Tools::getValue('id_product'), Tools::getValue('related_link'));
        }
    }

    public function renderForm()
    {
        $fields_form = array(
            'form' => array(
                'legend'      => array(
                    'title' => $this->l('Settings of the module'),
                    'icon'  => 'icon-cubes',
                ),
                'description' => $this->l('With this form you will configure global settings of the module. If you are looking for form to define "related products" - you can find it on each product edit page (there is a section with modules where you can manage this module settings)'),
                'input'       => array(
                    array(
                        'type'  => 'text',
                        'label' => $this->l('Path to .tpl file of product miniature'),
                        'name'  => 'rf_tpath',
                        'desc'  => $this->l('default value for Prestashop 1.7 classic theme: catalog/_partials/miniatures/product.tpl') . '<br/>' . $this->l('If you want to use non-default path - make sure that this file exists, otherwise website will spawn error about "unable to load template file"') . '<div class="alert alert-info">' . $this->l('Module to build list of products will use theme file that is responsible for "miniature" of product on list of products. If your theme does not follow prestashop standards and uses own not-default .tpl files - you can type here the path to this .tpl file. This option makes the module compatible with all themes.') . '</div>',
                    ),
                    array(
                        'type'  => 'text',
                        'label' => $this->l('CSS class of main div with products'),
                        'name'  => 'rf_maincss',
                        'desc'  => $this->l('default value for Prestashop 1.7 classic theme: "featured-products clearfix"'),
                    ),
                    array(
                        'type'  => 'text',
                        'label' => $this->l('CSS class of block with products'),
                        'name'  => 'rf_productscss',
                        'desc'  => $this->l('default value for Prestashop 1.7 classic theme: "products row"'),
                    ),
                ),
                'submit'      => array(
                    'title' => $this->l('Save'),
                )
            ),
        );

        $helper                           = new HelperForm();
        $helper->default_form_language    = $this->context->language->id;
        $helper->allow_employee_form_lang = Configuration::get('PS_BO_ALLOW_EMPLOYEE_FORM_LANG') ? Configuration::get('PS_BO_ALLOW_EMPLOYEE_FORM_LANG') : 0;
        $helper->identifier               = 'rf_settings';
        $helper->submit_action            = 'btnSubmit';
        $helper->currentIndex             = $this->context->link->getAdminLink('AdminModules', false) . '&configure=' . $this->name . '&tab_module=' . $this->tab . '&module_name=' . $this->name;
        $helper->token                    = Tools::getAdminTokenLite('AdminModules');
        $helper->tpl_vars                 = array(
            'fields_value' => $this->getConfigFieldsValues(),
            'languages'    => $this->context->controller->getLanguages(),
            'id_language'  => $this->context->language->id
        );

        return $helper->generateForm(array($fields_form));
    }

    public function getConfigFieldsValues()
    {
        return array(
            'rf_tpath' => Tools::getValue('ppb_customtplpath', $this->return_rf_tpath()),
            'rf_maincss' => Tools::getValue('rf_maincss', Configuration::get('rf_maincss')),
            'rf_productscss' => Tools::getValue('rf_productscss', Configuration::get('rf_productscss')),
        );
    }    

    public function hookdisplayAdminProductsExtra($params)
    {
        $_GET['id_product'] = $params['id_product'];
        $this->context->smarty->assign('id_product', Tools::getValue('id_product'));
        $this->context->smarty->assign('related_category', Configuration::get('related_category' . Tools::getValue('id_product')));
        $this->context->smarty->assign('related_nb', Configuration::get('related_nb' . Tools::getValue('id_product')));
        $this->context->smarty->assign('related_link', Configuration::get('related_link' . Tools::getValue('id_product')));
        $this->context->smarty->assign('physical_uri', $this->context->shop->physical_uri);
        $this->context->smarty->assign('virtual_uri', $this->context->shop->virtual_uri);
        $this->context->smarty->assign('secure_key', $this->secure_key);
        return $this->display(__FILE__, 'views/templates/admin/tabs.tpl');
    }

    public function hookdisplayFooterProduct($params)
    {
        return $this->hookdisplayProductFooter($params);
    }

    public function hookdisplayProductFooter($params)
    {
        $idProduct = $this->getIdProductFromParams($params);
        if (!$idProduct) {
            return '';
        }
        $category = new Category(Configuration::get('related_category' . $idProduct));
        $blocks_products = $category->getProducts($this->context->language->id, 0, Configuration::get('related_nb' . $idProduct));
        $products = $this->prepareBlocksProducts($blocks_products);
        $this->context->smarty->assign('related_link', Configuration::get('related_link' . $idProduct));
        $this->context->smarty->assign('related_category', Configuration::get('related_category' . $idProduct));
        $this->context->smarty->assign('related_nb', Configuration::get('related_nb' . $idProduct));
        $this->context->smarty->assign('products', $products);
        $this->context->smarty->assign('rf_tpath', $this->return_rf_tpath());
        $this->context->smarty->assign('rf_maincss', Configuration::get('rf_maincss'));
        $this->context->smarty->assign('id_lang', $this->context->language->id);
        $this->context->smarty->assign('rf_productscss', Configuration::get('rf_productscss'));

        return $this->context->smarty->fetch('module:relatedfree/views/templates/hook/productFooter.tpl');
    }

    /**
     * Get product id from hook params (PS 1.7/8/9) or request.
     * @param array $params
     * @return int
     */
    private function getIdProductFromParams($params)
    {
        if (isset($params['product']['id_product'])) {
            return (int) $params['product']['id_product'];
        }
        if (isset($params['product']['id'])) {
            return (int) $params['product']['id'];
        }
        if (isset($params['id_product'])) {
            return (int) $params['id_product'];
        }
        return (int) Tools::getValue('id_product', 0);
    }

    public function prepareBlocksProducts($products)
    {
        if ($products == false) {
            return false;
        }

        $assemblerClass = $this->resolveProductAssemblerClass();
        $presenterFactoryClass = $this->resolveProductPresenterFactoryClass();
        if (!$assemblerClass || !$presenterFactoryClass) {
            return $this->prepareBlocksProductsFallback($products);
        }

        $assembler = new $assemblerClass($this->context);
        $presenterFactory = new $presenterFactoryClass($this->context);
        $presentationSettings = $presenterFactory->getPresentationSettings();
        $presenter = new ProductListingPresenter(
            new ImageRetriever($this->context->link),
            $this->context->link,
            new PriceFormatter(),
            new ProductColorsRetriever(),
            $this->context->getTranslator()
        );
        $products_for_template = [];
        foreach ($products as $rawProduct) {
            $productArray = is_array($rawProduct) ? $rawProduct : (array) $rawProduct;
            $assembled = $assembler->assembleProduct($productArray);
            $products_for_template[] = $presenter->present($presentationSettings, $assembled, $this->context->language);
        }
        return $products_for_template;
    }

    /**
     * Resolve ProductAssembler class name (differs between PS 1.7/8/9 and installs).
     * @return string|null
     */
    private function resolveProductAssemblerClass()
    {
        $candidates = array(
            'ProductAssembler',           // PS 1.7+ global / classmap
            'ProductAssemblerCore',       // PS 1.7 classes/ProductAssembler.php
            'PrestaShop\\PrestaShop\\Core\\Product\\ProductAssembler',
            'PrestaShop\\PrestaShop\\Adapter\\Presenter\\Product\\ProductAssembler',
        );
        foreach ($candidates as $class) {
            if (class_exists($class)) {
                return $class;
            }
        }
        return null;
    }

    /**
     * Resolve ProductPresenterFactory class name (differs between PS 1.7/8/9 and installs).
     * @return string|null
     */
    private function resolveProductPresenterFactoryClass()
    {
        $candidates = array(
            'ProductPresenterFactory',    // PS 1.7+ global / classmap
            'PrestaShop\\PrestaShop\\Core\\Product\\ProductPresenterFactory',
            'PrestaShop\\PrestaShop\\Adapter\\Presenter\\Product\\ProductPresenterFactory',
        );
        foreach ($candidates as $class) {
            if (class_exists($class)) {
                return $class;
            }
        }
        return null;
    }

    /**
     * Fallback when ProductAssembler/ProductPresenterFactory are not available: return products as simple arrays.
     * @param array $products
     * @return array
     */
    private function prepareBlocksProductsFallback($products)
    {
        $out = array();
        foreach ($products as $rawProduct) {
            $p = is_array($rawProduct) ? $rawProduct : (array) $rawProduct;
            $out[] = array_merge(array(
                'id_product' => isset($p['id_product']) ? $p['id_product'] : 0,
                'name' => isset($p['name']) ? $p['name'] : '',
                'link' => isset($p['link']) ? $p['link'] : '',
                'price' => isset($p['price']) ? $p['price'] : 0,
                'cover' => isset($p['id_product']) ? array('url' => $this->context->link->getImageLink(isset($p['link_rewrite']) ? $p['link_rewrite'] : 'product', $p['id_product'])) : array('url' => ''),
            ), $p);
        }
        return $out;
    }
}

require_once dirname(__FILE__) . '/updateChecker.php';