<?php
/**
 * Update checker for Featured Category module (MyPresta.eu).
 * mibUpdate extends mib – $this in update methods is the module, $this->l() works.
 *
 * @author    VEKIA
 * @copyright 2010-2026 VEKIA
 */

if (!defined('_PS_VERSION_')) {
    exit;
}

/**
 * Update logic and form. Extends mib (which extends Module).
 */
class mibUpdate extends mib
{
    /** @var string License key for updates */
    public $mkey;

    public function __construct()
    {
        parent::__construct();
    }

    public function runUpdateSetUp()
    {
        $this->mkey = 'nlc';
        if (@file_exists(_PS_MODULE_DIR_ . $this->name . '/key.php')) {
            @require_once(_PS_MODULE_DIR_ . $this->name . '/key.php');
        }

        if (!defined('_PS_ADMIN_DIR_')) {
            return;
        }

        $update_interval = 259200; // 3 days
        $last_update = (int)Configuration::get('update_' . $this->name);

        if (Configuration::get('mypresta_updates') != 0) {
            if ($last_update < (time() - $update_interval)) {
                Configuration::updateValue('update_' . $this->name, (string)time());
                self::verify($this->name, isset($this->mkey) ? $this->mkey : 'nokey', $this->version);
            }

            $available_version = Configuration::get('updatev_' . $this->name);
            if ($available_version && version_compare($this->version, $available_version, '<') && Tools::getValue('ajax', 'false') == 'false') {
                $this->context->controller->warnings[] = '<strong>' . $this->displayName . '</strong>: ' . $this->l('New version available, check http://MyPresta.eu for more informations', 'updatechecker') . ' <a href="' . $this->mypresta_link . '">' . $this->l('More details in changelog', 'updatechecker') . '</a>';

            }
        }
    }

    public function checkforupdates($display_msg = 0, $form = 0)
    {
        $output = '';

        if (Tools::isSubmit('submit_settings_updates_now')) {
            self::verify($this->name, isset($this->mkey) ? $this->mkey : 'nokey', $this->version);
            return $this->renderUpdateForm();
        }

        if (Tools::isSubmit('submit_settings_updates')) {
            Configuration::updateValue('mypresta_updates', (int)Tools::getValue('mypresta_updates'));
            $output .= $this->displayConfirmation($this->l('Update settings saved.', 'updatechecker'));
        }

        if ($form == 1) {
            return $output . $this->renderUpdateForm();
        }

        if ($display_msg == 1) {
            $available_version = Configuration::get('updatev_' . $this->name);
            if ($available_version && version_compare($this->version, $available_version, '<')) {
                return "<span style='color:red; font-weight:bold; font-size:16px; margin-right:10px;'>" . $this->l('New version available!', 'updatechecker') . "</span>";
            }
            return "<span style='color:green; font-weight:bold; font-size:16px; margin-right:10px;'>" . $this->l('Module is up to date!', 'updatechecker') . "</span>";
        }

        return $output;
    }

    private function renderUpdateForm()
    {
        $fields_form = array(
            'form' => array(
                'legend' => array('title' => $this->l('MyPresta Updates', 'updatechecker'), 'icon' => 'icon-wrench'),
                'input' => array(
                    array(
                        'type' => 'free',
                        'label' => $this->l('Manual Check', 'updatechecker'),
                        'name' => 'check_updates_btn',
                        'desc' => $this->l('Manually check if a new version of this module is available on MyPresta.eu servers.', 'updatechecker')
                    ),
                    array(
                        'type' => 'select',
                        'label' => $this->l('Automatic Notifications', 'updatechecker'),
                        'name' => 'mypresta_updates',
                        'options' => array(
                            'query' => array(
                                array('id' => '1', 'name' => $this->l('Enabled', 'updatechecker')),
                                array('id' => '0', 'name' => $this->l('Disabled', 'updatechecker')),
                            ),
                            'id' => 'id',
                            'name' => 'name'
                        ),
                        'desc' => $this->l('This option when active will display notification about availability of new module version in your shop\'s back office', 'updatechecker')
                    ),
                    array(
                        'type' => 'free',
                        'label' => $this->l('Product Page', 'updatechecker'),
                        'name' => 'module_page_link',
                        'desc' => $this->l('This is a direct link to official module page where you can read about module, its updates etc.', 'updatechecker')

                    ),
                ),
                'submit' => array('title' => $this->l('Save', 'updatechecker'), 'class' => 'btn btn-default pull-right', 'name' => 'submit_settings_updates')
            )
        );

        $helper = new HelperForm();
        $helper->module = $this;
        $helper->token = Tools::getAdminTokenLite('AdminModules');
        $helper->currentIndex = AdminController::$currentIndex . '&configure=' . $this->name;

        if (Tools::isSubmit('submit_settings_updates_now')) {
            $av = Configuration::get('updatev_' . $this->name);
            $msg = ($av && version_compare($this->version, $av, '<'))
                ? "<span style='color:red; font-weight:bold; font-size:16px; margin-right:10px;'>" . $this->l('New version available!', 'updatechecker') . "</span>"
                : "<span style='color:green; font-weight:bold; font-size:16px; margin-right:10px;'>" . $this->l('Module is up to date!', 'updatechecker') . "</span>";
        } else {
            $msg = '';
        }
        $check_btn = $msg . '<button type="submit" name="submit_settings_updates_now" class="btn btn-default"><i class="process-icon-update"></i> ' . $this->l('Check Now', 'updatechecker') . '</button>';

        $helper->tpl_vars = array(
            'fields_value' => array(
                'check_updates_btn' => $check_btn,
                'mypresta_updates' => Configuration::get('mypresta_updates'),
                'module_page_link' => '<a href="' . $this->mypresta_link . '" target="_blank">' . $this->displayName . '</a>'
            ),
            'languages' => Context::getContext()->controller->getLanguages(),
            'id_language' => Context::getContext()->language->id
        );

        return $helper->generateForm(array($fields_form));
    }

    public static function verify($module_name, $key, $version)
    {
        $url = 'https://dev.mypresta.eu/update/get.php?module=' . $module_name . '&version=' . base64_encode($version) . '&lic=' . $key . '&u=' . base64_encode(_PS_BASE_URL_ . __PS_BASE_URI__);
        $actual_version = '';

        if (function_exists('curl_init')) {
            $ch = curl_init();
            curl_setopt($ch, CURLOPT_URL, $url);
            curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
            curl_setopt($ch, CURLOPT_TIMEOUT, 3);
            curl_setopt($ch, CURLOPT_CONNECTTIMEOUT, 3);
            curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, false);
            curl_setopt($ch, CURLOPT_USERAGENT, 'PrestaShop Module Update');
            $actual_version = curl_exec($ch);
            curl_close($ch);
        }

        if (empty($actual_version) && ini_get('allow_url_fopen')) {
            $context = stream_context_create(array('http' => array('timeout' => 3.0)));
            $actual_version = @file_get_contents($url, false, $context);
        }

        $actual_version = strip_tags(trim($actual_version));

        Configuration::updateValue('update_' . $module_name, (string)time());
        Configuration::updateValue('updatev_' . $module_name, (string)$actual_version);

        return $actual_version;
    }

    public function inconsistency()
    {
        return '';
    }
}

require_once dirname(__FILE__) . '/updateChecker.php';