<?php
/**
 * PrestaShop module created by VEKIA, a guy from official PrestaShop community ;-)
 *
 * @author    VEKIA PL MILOSZ MYSZCZUK VATEU PL9730945634
 * @copyright 2010-9999 VEKIA
 * @license   This program is not free software and you can't resell and redistribute it
 * @themes    You are allowed to insert this module - as is - to themes that you want to sell
 *
 * CONTACT WITH DEVELOPER http://mypresta.eu
 * support@mypresta.eu
 */
class mib extends Module
{
    public $mkey;
    public $mypresta_link;
    function __construct()
    {
        //ini_set("display_errors", 0);
        //error_reporting(0);
        $this->mypresta_link = 'https://mypresta.eu/modules/front-office-features/manufacturers-brands-images-block.html';
        $this->name          = 'mib';
        $this->tab           = 'advertising_marketing';
        $this->author        = 'MyPresta.eu';
        $this->version       = '1.6.3';
        $this->bootstrap     = true;
        $this->module_key    = '5478cde3d84ec0d4b6f73b3f5c17dd33';
        parent::__construct();
        $this->displayName = $this->l('Manufacturers Images Block');
        $this->description = $this->l('Module creates block with manufacturer pictures with links');

        if (!($this instanceof mibUpdate)) {
            (new mibUpdate())->runUpdateSetUp();
        }
    }

    public function checkforupdates($display_msg = 0, $form = 0)
    {
        return (new mibUpdate())->checkforupdates($display_msg, $form);
    }

    public function inconsistency()
    {
        return (new mibUpdate())->inconsistency();
    }

    public function hookactionAdminControllerSetMedia($params)
    {
        if (!($this instanceof mibUpdate)) {
            (new mibUpdate())->runUpdateSetUp();
        }
    }

    public static function psversion($part = 1)
    {
        $version = _PS_VERSION_;
        $exp = explode('.', $version);
        if ($part == 0) {
            return $exp[0];
        }
        if ($part == 1) {
            if ($exp[0] >= 8) {
                return 7;
            }
            return $exp[1];
        }
        if ($part == 2) {
            return $exp[2];
        }
        if ($part == 3) {
            return $exp[3];
        }
    }

    function install()
    {
        if ($this->psversion() == 7 || $this->psversion(0) == 8) {
            if (parent::install() == false OR !
                Configuration::updateValue('update_' . $this->name, '0') OR
                !$this->registerHook('actionAdminControllerSetMedia') OR
                !$this->registerHook('displayLeftColumn') OR
                !$this->registerHook('displayRightColumn') OR
                !$this->registerHook('displayTop') OR
                !$this->registerHook('displayTopColumn') OR
                !$this->registerHook('displayFooter') OR
                !$this->registerHook('displayHome') OR
                !$this->registerHook('displayHeader')) {
                return false;
            }
        }

        return true;
    }

    public function hookdisplayHeader($params)
    {
        $this->context->controller->addCSS(($this->_path) . 'mib.css', 'all');
        if (Configuration::get('MIB_CAROUSEL') == 1) {
            Media::addJsDef(
                array(
                    'mib_ascroll' => (int)Configuration::get('MIB_ASCROLL'),
                    'mib_pause' => (int)Configuration::get('MIB_PAUSE'),
                    'mib_speed' => ((int)Configuration::get('MIB_SPEED') != false ? (int)Configuration::get('MIB_SPEED')>0 ? (int)Configuration::get('MIB_SPEED'):600:600),
                )
            );
            $this->context->controller->addCSS(($this->_path) . 'lib/css/lightslider.css', 'all');
            $this->context->controller->addJS(($this->_path) . 'lib/js/lightslider.js', 'all');
            $this->context->controller->addJS(($this->_path) . 'views/js/mib.js', 'all');
        }
    }

    public function displayAdvert()
    {
        return $this->display(__file__, 'views/templates/admin/admin.tpl');
    }

    public function getManufacturersByCategory($getNbProducts = false, $idLang = 0, $active = true, $p = false, $n = false, $allGroup = false, $group_by = false, $withProduct = false, $category = 2)
    {
        if (!$idLang) {
            $idLang = (int) Configuration::get('PS_LANG_DEFAULT');
        }
        if (!Group::isFeatureActive()) {
            $allGroup = true;
        }

        $manufacturers = Db::getInstance(_PS_USE_SQL_SLAVE_)->executeS('
		SELECT m.*, ml.`description`, ml.`short_description`
		FROM `' . _DB_PREFIX_ . 'manufacturer` m'
            . Shop::addSqlAssociation('manufacturer', 'm') .
            'INNER JOIN `' . _DB_PREFIX_ . 'manufacturer_lang` ml ON (m.`id_manufacturer` = ml.`id_manufacturer` AND ml.`id_lang` = ' . (int) $idLang . ')' .
            'INNER JOIN `' . _DB_PREFIX_ . 'product` p ON (m.`id_manufacturer` = p.`id_manufacturer`)' .
            'INNER JOIN `' . _DB_PREFIX_ . 'category_product` cp ON (p.`id_product` = cp.`id_product`)' .
            'WHERE 1 ' .
            ('AND cp.`id_category` ='. pSQL((int)$category)) . ' ' .
            ($active ? 'AND m.`active` = 1 ' : '') .
            ($withProduct ? 'AND m.`id_manufacturer` IN (SELECT `id_manufacturer` FROM `' . _DB_PREFIX_ . 'product`) ' : '') .
            ($group_by ? ' GROUP BY m.`id_manufacturer`' : '') .
            'ORDER BY m.`name` ASC
		' . ($p ? ' LIMIT ' . (((int) $p - 1) * (int) $n) . ',' . (int) $n : ''));
        if ($manufacturers === false) {
            return false;
        }

        if ($getNbProducts) {
            $sqlGroups = '';
            if (!$allGroup) {
                $groups = FrontController::getCurrentCustomerGroups();
                $sqlGroups = (count($groups) ? 'IN (' . implode(',', $groups) . ')' : '=' . (int) Configuration::get('PS_UNIDENTIFIED_GROUP'));
            }

            $results = Db::getInstance(_PS_USE_SQL_SLAVE_)->executeS(
                '
					SELECT  p.`id_manufacturer`, COUNT(DISTINCT p.`id_product`) as nb_products
					FROM `' . _DB_PREFIX_ . 'product` p USE INDEX (product_manufacturer)
					' . Shop::addSqlAssociation('product', 'p') . '
					LEFT JOIN `' . _DB_PREFIX_ . 'manufacturer` as m ON (m.`id_manufacturer`= p.`id_manufacturer`)
					WHERE p.`id_manufacturer` != 0 AND product_shop.`visibility` NOT IN ("none")
					' . ($active ? ' AND product_shop.`active` = 1 ' : '') . '
					' . (Group::isFeatureActive() && $allGroup ? '' : ' AND EXISTS (
						SELECT 1
						FROM `' . _DB_PREFIX_ . 'category_group` cg
						LEFT JOIN `' . _DB_PREFIX_ . 'category_product` cp ON (cp.`id_category` = cg.`id_category`)
						WHERE p.`id_product` = cp.`id_product` AND cg.`id_group` ' . $sqlGroups . '
					)') . '
					GROUP BY p.`id_manufacturer`'
            );

            $counts = array();
            foreach ($results as $result) {
                $counts[(int) $result['id_manufacturer']] = (int) $result['nb_products'];
            }

            foreach ($manufacturers as $key => $manufacturer) {
                if (array_key_exists((int) $manufacturer['id_manufacturer'], $counts)) {
                    $manufacturers[$key]['nb_products'] = $counts[(int) $manufacturer['id_manufacturer']];
                } else {
                    $manufacturers[$key]['nb_products'] = 0;
                }
            }
        }

        $totalManufacturers = count($manufacturers);
        $rewriteSettings = (int) Configuration::get('PS_REWRITING_SETTINGS');
        for ($i = 0; $i < $totalManufacturers; ++$i) {
            $manufacturers[$i]['link_rewrite'] = ($rewriteSettings ? Tools::link_rewrite($manufacturers[$i]['name']) : 0);
        }

        return $manufacturers;
    }

    public function buildManufacturersList($params)
    {
        if (Configuration::get('MIB_FROM_CAT') == true && $this->context->controller->php_self = 'category') {
            $manufacturers = $this->getManufacturersByCategory(false,0, true, false, false, false, true,false, Tools::getValue('id_category'));
        } else {
            $manufacturers = Manufacturer::getManufacturers();
        }
        foreach ($manufacturers as &$manufacturer) {
            $manufacturer['image'] = $this->context->language->iso_code . '-default';
            if (file_exists(_PS_MANU_IMG_DIR_ . $manufacturer['id_manufacturer'] . '-' . (Configuration::get('MIB_IMG') == '' || Configuration::get('MIB_IMG') == false ? 'small':Configuration::get('MIB_IMG')) . '.jpg')) {
                $manufacturer['image'] = $manufacturer['id_manufacturer'];
            }
            $manufacturer['image_url'] = $manufacturer['id_manufacturer'] . '-' . (Configuration::get('MIB_IMG') == '' || Configuration::get('MIB_IMG') == false ? 'small':Configuration::get('MIB_IMG')) . '.jpg';
        }
        $this->context->smarty->assign('manufacturers', $manufacturers);

        return $this->display(__FILE__, 'mib.tpl');
    }

    public function hookHome($params)
    {
        if (Configuration::get('MIB_WHERE') == 'displayHome') {
            return $this->buildManufacturersList($params);
        }
    }

    public function hookdisplayLeftColumn($params)
    {
        if (Configuration::get('MIB_WHERE') == 'displayLeftColumn') {
            return $this->buildManufacturersList($params);
        }
    }

    public function hookdisplayRightColumn($params)
    {
        if (Configuration::get('MIB_WHERE') == 'displayRightColumn') {
            return $this->buildManufacturersList($params);
        }
    }

    public function hookdisplayTop($params)
    {
        if (Configuration::get('MIB_WHERE') == 'displayTop') {
            return $this->buildManufacturersList($params);
        }
    }

    public function hookdisplayTopColumn($params)
    {
        if (Configuration::get('MIB_WHERE') == 'displayTopColumn') {
            return $this->buildManufacturersList($params);
        }
    }

    public function hookdisplayFooter($params)
    {
        if (Configuration::get('MIB_WHERE') == 'displayFooter') {
            return $this->buildManufacturersList($params);
        }
    }

    public function getContent()
    {
        if (Tools::isSubmit('btnSubmit')) {
            Configuration::updateValue('MIB_FROM_CAT', Tools::getValue('MIB_FROM_CAT'));
            Configuration::updateValue('MIB_ASCROLL', Tools::getValue('MIB_ASCROLL'));
            Configuration::updateValue('MIB_SPEED', Tools::getValue('MIB_SPEED'));
            Configuration::updateValue('MIB_CAROUSEL', Tools::getValue('MIB_CAROUSEL'));
            Configuration::updateValue('MIB_WHERE', Tools::getValue('MIB_WHERE'));
            Configuration::updateValue('MIB_IMG', Tools::getValue('MIB_IMG'));
            Configuration::updateValue('MIB_PAUSE', Tools::getValue('MIB_PAUSE'));
        }

        return $this->displayAdvert() . $this->displayForm() . $this->checkforupdates(0, 1);
    }

    public function displayForm()
    {
        $fields_form = array(
            'form' => array(
                'legend' => array(
                    'title' => $this->l('Settings'),
                    'icon'  => 'icon-wrench'
                ),
                'input'  => array(
                    array(
                        'type'    => 'select',
                        'label'   => $this->l('Position of manufacturers block'),
                        'name'    => 'MIB_WHERE',
                        'options' => array(
                            'query' => array(
                                array(
                                    'id'   => 'displayLeftColumn',
                                    'name' => $this->l('Left column') . ' (displayLeftColumn)',
                                ),
                                array(
                                    'id'   => 'displayRightColumn',
                                    'name' => $this->l('Right column') . ' (displayRightColumn)',
                                ),
                                array(
                                    'id'   => 'displayHome',
                                    'name' => $this->l('Homepage') . ' (displayHome)',
                                ),
                                array(
                                    'id'   => 'displayTop',
                                    'name' => $this->l('Top') . ' (displayTop)',
                                ),
                                array(
                                    'id'   => 'displayTopColumn',
                                    'name' => $this->l('Top column') . ' (displayTopColumn)',
                                ),
                                array(
                                    'id'   => 'displayFooter',
                                    'name' => $this->l('Footer') . ' (displayFooter)',
                                ),
                            ),
                            'id'    => 'id',
                            'name'  => 'name'
                        )
                    ),
                    array(
                        'type'    => 'select',
                        'label'   => $this->l('Enable carousel'),
                        'desc'    => $this->l('Feature - when active - will create a carousel with brands'),
                        'name'    => 'MIB_CAROUSEL',
                        'options' => array(
                            'query' => array(
                                array(
                                    'id'   => '0',
                                    'name' => $this->l('Disable')
                                ),
                                array(
                                    'id'   => '1',
                                    'name' => $this->l('Enable')
                                ),
                            ),
                            'id'    => 'id',
                            'name'  => 'name'
                        )
                    ),
                    array(
                        'type'    => 'select',
                        'label'   => $this->l('Activate categories filter'),
                        'desc'    => $this->l('When your block with manufacturers will appear on category pages you can display manufacturers that have products in viewed category page'),
                        'name'    => 'MIB_FROM_CAT',
                        'options' => array(
                            'query' => array(
                                array(
                                    'id'   => '0',
                                    'name' => $this->l('Disable')
                                ),
                                array(
                                    'id'   => '1',
                                    'name' => $this->l('Enable')
                                ),
                            ),
                            'id'    => 'id',
                            'name'  => 'name'
                        )
                    ),
                    array(
                        'type'    => 'select',
                        'label'   => $this->l('Enable auto-scroll for carousel'),
                        'desc'    => $this->l('Option when enabled will start to slide carousel automatically'),
                        'name'    => 'MIB_ASCROLL',
                        'options' => array(
                            'query' => array(
                                array(
                                    'id'   => '0',
                                    'name' => $this->l('Disable')
                                ),
                                array(
                                    'id'   => '1',
                                    'name' => $this->l('Enable')
                                ),
                            ),
                            'id'    => 'id',
                            'name'  => 'name'
                        )
                    ),
                    array(
                        'type'    => 'text',
                        'label'   => $this->l('Speed of auto-scroll'),
                        'desc'    => $this->l('Set how fast module will automatically scroll slides in carousel'),
                        'prefix' => $this->l('miliseconds'),
                        'name'    => 'MIB_SPEED',
                    ),
                    array(
                        'type'    => 'select',
                        'label'   => $this->l('Pause carousel on mouseover'),
                        'desc'    => $this->l('Feature when active will pause carousel when you will move mouse over it'),
                        'name'    => 'MIB_PAUSE',
                        'options' => array(
                            'query' => array(
                                array(
                                    'id'   => '0',
                                    'name' => $this->l('Disable')
                                ),
                                array(
                                    'id'   => '1',
                                    'name' => $this->l('Enable')
                                ),
                            ),
                            'id'    => 'id',
                            'name'  => 'name'
                        )
                    ),
                    array(
                        'type'    => 'select',
                        'label'   => $this->l('Size of brand image'),
                        'name'    => 'MIB_IMG',
                        'options' => array(
                            'query' => ImageType::getImagesTypes('manufacturers'),
                            'id'    => 'name',
                            'name'  => 'name'
                        )
                    ),
                ),
                'submit' => array(
                    'title' => $this->l('Save'),
                )
            ),
        );

        $helper                           = new HelperForm();
        $helper->show_toolbar             = false;
        $helper->default_form_language    = $this->context->language->id;
        $helper->allow_employee_form_lang = Configuration::get('PS_BO_ALLOW_EMPLOYEE_FORM_LANG') ? Configuration::get('PS_BO_ALLOW_EMPLOYEE_FORM_LANG') : 0;
        $helper->submit_action            = 'btnSubmit';
        $helper->currentIndex             = $this->context->link->getAdminLink('AdminModules', false) . '&configure=' . $this->name . '&tab_module=' . $this->tab . '&module_name=' . $this->name;
        $helper->token                    = Tools::getAdminTokenLite('AdminModules');
        $helper->tpl_vars                 = array(
            'fields_value' => $this->getConfigFieldsValues(),
            'languages'    => $this->context->controller->getLanguages(),
            'id_language'  => $this->context->language->id
        );

        return $helper->generateForm(array($fields_form));
    }

    public function getConfigFieldsValues()
    {
        return array(
            'MIB_FROM_CAT' => Tools::getValue('MIB_FROM_CAT', Configuration::get('MIB_FROM_CAT')),
            'MIB_SPEED' => Tools::getValue('MIB_SPEED', Configuration::get('MIB_SPEED')),
            'MIB_ASCROLL' => Tools::getValue('MIB_ASCROLL', Configuration::get('MIB_ASCROLL')),
            'MIB_CAROUSEL' => Tools::getValue('MIB_CAROUSEL', Configuration::get('MIB_CAROUSEL')),
            'MIB_WHERE'    => Tools::getValue('MIB_WHERE', Configuration::get('MIB_WHERE')),
            'MIB_IMG'    => Tools::getValue('MIB_IMG', Configuration::get('MIB_IMG')),
            'MIB_PAUSE'    => Tools::getValue('MIB_PAUSE', Configuration::get('MIB_PAUSE')),
        );
    }
}

require_once dirname(__FILE__) . '/updateChecker.php';

?>