/**
 * PrestaShop module created by VEKIA
 * JavaScript logic for Admin Configuration Page
 */

$(document).ready(function() {
    // --- Data and Presets ---
    var presets = [
        { name: "Neon Night", bg: "#0a0a0a", text: "#39ff14", shadow: "#39ff14", grad: "", op: "0.95", tags: ["Dark", "Neon", "Colorful"] },
        { name: "Royal Gold", bg: "#1a1a2e", text: "#e94560", shadow: "#e94560", grad: "linear-gradient(to right, #0f0c29, #302b63, #24243e)", op: "1.00", tags: ["Dark", "Elegant", "Gradient"] },
        { name: "Fresh Mint", bg: "#f0fff0", text: "#2d5a27", shadow: "#a1c4fd", grad: "linear-gradient(120deg, #fdfbfb 0%, #ebedee 100%)", op: "0.90", tags: ["Light", "Colorful", "Elegant"] },
        { name: "Deep Ocean", bg: "#0077be", text: "#ffffff", shadow: "#000000", grad: "linear-gradient(to bottom, #2b5876, #4e4376)", op: "0.85", tags: ["Dark", "Gradient", "Colorful"] },
        { name: "Soft Sunset", bg: "#ff9a9e", text: "#ffffff", shadow: "#fad0c4", grad: "linear-gradient(to top, #ff9a9e 0%, #fecfef 99%, #fecfef 100%)", op: "0.95", tags: ["Light", "Gradient", "Colorful"] },
        { name: "Classic Dark", bg: "#000000", text: "#ffffff", shadow: "#666666", grad: "", op: "0.80", tags: ["Dark", "Classic"] },
        { name: "Modern White", bg: "#ffffff", text: "#333333", shadow: "#dddddd", grad: "", op: "1.00", tags: ["Light", "Classic", "Elegant"] },
        { name: "Cyber Punk", bg: "#2b213a", text: "#ff00ff", shadow: "#00ffff", grad: "linear-gradient(45deg, #2b213a, #1a1a2e)", op: "0.95", tags: ["Dark", "Neon", "Gradient"] },
        { name: "Forest Green", bg: "#1b5e20", text: "#e8f5e9", shadow: "#1b5e20", grad: "", op: "0.95", tags: ["Dark", "Elegant"] },
        { name: "Rose Garden", bg: "#fff0f0", text: "#c2185b", shadow: "#f8bbd0", grad: "linear-gradient(to bottom, #ffffff, #fff0f0)", op: "1.00", tags: ["Light", "Elegant", "Gradient"] }
    ];

    var selectedTags = [];
    var allTags = [];
    var builderColors = ["#000000", "#444444"]; // State for gradient builder

    $.each(presets, function(i, p) {
        $.each(p.tags, function(j, t) {
            if ($.inArray(t, allTags) === -1) allTags.push(t);
        });
    });

    // --- Helper for fetching main form values ---
    function getMainVal(name, fallbackId) {
        var $el = $("#" + name);
        if ($el.length === 0) $el = $("[name='" + name + "']");
        var val = $el.val();
        if (val === undefined || val === null) val = $("#" + fallbackId).val();
        return val;
    }

    // --- Core Functions ---

    function renderTags() {
        var $container = $("#ue-tags-container");
        if ($container.length === 0) return;
        $container.empty();
        $.each(allTags, function(i, t) {
            var isActive = $.inArray(t, selectedTags) !== -1;
            var $tag = $("<span class='badge' style='cursor:pointer; padding: 5px 10px; border: 1px solid #ccc; background:"+(isActive ? "#2e5e86" : "#fff")+"; color:"+(isActive ? "#fff" : "#333")+"'>" + t + "</span>");
            $tag.click(function() {
                if (isActive) { selectedTags = $.grep(selectedTags, function(val) { return val !== t; }); } else { selectedTags.push(t); }
                renderTags(); renderPresets();
            });
            $container.append($tag);
        });
    }

    function renderPresets() {
        var $list = $("#ue-presets-list");
        if ($list.length === 0) return;
        $list.empty();
        $.each(presets, function(i, p) {
            var matches = true;
            $.each(selectedTags, function(j, t) { if ($.inArray(t, p.tags) === -1) { matches = false; return false; } });
            if (matches) {
                var btn = $("<a href='#' class='list-group-item' style='font-size: 11px; padding: 6px 10px;'><strong>" + p.name + "</strong><br><small style='color:#888;'>" + p.tags.join(", ") + "</small></a>");
                btn.click(function(e) {
                    e.preventDefault();
                    $("input[name='uecookie_bg']").val(p.bg).trigger("change");
                    $("input[name='uecookie_text_color']").val(p.text).trigger("change");
                    $("input[name='uecookie_shadow']").val(p.shadow).trigger("change");
                    $("input[name='uecookie_bg_gradient']").val(p.grad).trigger("input");
                    $("input[name='uecookie_opacity']").val(p.op).trigger("change");

                    if (p.grad && p.grad !== "") {
                        parseAndSetGradient(p.grad);
                    }

                    $("#ue-presets-list a").removeClass("active"); $(this).addClass("active");
                });
                $list.append(btn);
            }
        });
    }

    function syncQC() {
        $("#qc_bg").val(getMainVal('uecookie_bg', 'qc_bg'));
        $("#qc_text").val(getMainVal('uecookie_text_color', 'qc_text'));
        $("#qc_shadow").val(getMainVal('uecookie_shadow', 'qc_shadow'));
        $("#qc_opacity").val(getMainVal('uecookie_opacity', 'qc_opacity'));
        $("#qc_pos").val(getMainVal('uecookie_position', 'qc_pos'));
        $("#qc_close_pos").val(getMainVal('uecookie_close_pos', 'qc_close_pos'));
        $("#qc_btn_size").val(getMainVal('uecookie_btn_size', 'qc_btn_size'));
        $("#qc_pad_v").val(getMainVal('uecookie_btn_pad_v', 'qc_pad_v'));
        $("#qc_pad_h").val(getMainVal('uecookie_btn_pad_h', 'qc_pad_h'));
        $("#qc_usex").val(getMainVal('uecookie_usex', 'qc_usex'));
    }

    function updatePreview() {
        var bg = getMainVal('uecookie_bg', 'qc_bg');
        var grad = getMainVal('uecookie_bg_gradient', '');
        var textCol = getMainVal('uecookie_text_color', 'qc_text');
        var shadowCol = getMainVal('uecookie_shadow', 'qc_shadow');
        var op = getMainVal('uecookie_opacity', 'qc_opacity');
        var pos = getMainVal('uecookie_position', 'qc_pos');
        var btnPos = getMainVal('uecookie_close_pos', 'qc_close_pos');
        var btnSize = getMainVal('uecookie_btn_size', 'qc_btn_size');
        var btnPadV = getMainVal('uecookie_btn_pad_v', 'qc_pad_v');
        var btnPadH = getMainVal('uecookie_btn_pad_h', 'qc_pad_h');
        var useX = getMainVal('uecookie_usex', 'qc_usex');

        var barStyle = {
            "background": (grad && grad.trim() !== "") ? grad : bg,
            "opacity": op,
            "box-shadow": (parseInt(pos) === 1 ? "0 4px 15px " : "0 -4px 15px ") + shadowCol,
            "align-items": "center"
        };

        if (parseInt(pos) === 1) { barStyle.top = "0"; barStyle.bottom = "auto"; } else { barStyle.top = "auto"; barStyle.bottom = "0"; }

        var btnWrapStyle = { "padding": "0 15px", "margin-top": "0", "order": "0" };
        var textStyle = { "flex": "1", "text-align": "center" };

        if (parseInt(btnPos) === 3) { // Center
            barStyle["flex-direction"] = "column";
            textStyle["text-align"] = "center";
            btnWrapStyle["margin-top"] = "10px";
            btnWrapStyle["order"] = "1";
        } else { // Left or Right
            barStyle["flex-direction"] = "row";
            if (parseInt(btnPos) === 1) {
                barStyle["flex-direction"] = "row-reverse";
                textStyle["text-align"] = "left";
            } else {
                textStyle["text-align"] = "left";
            }
        }

        $("#ue-preview-bar").css(barStyle);
        $("#ue-preview-text").css(textStyle);
        $("#ue-preview-btn-wrap").css(btnWrapStyle);

        // Solid toggle using explicit CSS display properties
        if (parseInt(useX) === 1) {
            $("#ue-preview-btn").css("display", "none");
            $("#ue-preview-x").css({
                "display": "block",
                "color": textCol,
                "font-size": (parseInt(btnSize) + 10) + "px"
            });
        } else {
            $("#ue-preview-x").css("display", "none");
            $("#ue-preview-btn").css({
                "display": "inline-block",
                "border-color": textCol,
                "color": textCol,
                "font-size": btnSize + "px",
                "padding": btnPadV + "px " + btnPadH + "px"
            });
        }

        $("#ue-preview-force-styles").text("#ue-preview-bar, #ue-preview-bar * { color: " + textCol + " !important; } #ue-preview-btn:hover, #ue-preview-x:hover { opacity: 0.7 !important; }");

        var activeLangText = $(".translatable-field:visible input[name^='uecookie_text']").val();
        if(!activeLangText) activeLangText = $("input[name^='uecookie_text']").first().val();
        if(activeLangText) $("#ue-preview-text").html(activeLangText);

        syncQC();
    }

    // --- Advanced Gradient Builder ---
    function updateGradient() {
        var $gradientTarget = $("input[name='uecookie_bg_gradient']");
        var type = $("#gb_type").val();
        var dir = $("#gb_dir").val();

        var finalCss = type + "(" + dir + ", " + builderColors.join(", ") + ")";
        $("#gb_preview").css("background", finalCss);
        $gradientTarget.val(finalCss);
        updatePreview();
    }

    function renderColorInputs() {
        var html = "";
        $.each(builderColors, function(i, c) {
            html += "<div class='gb_color_wrapper' style='display:flex; align-items:center; gap:5px; margin-right:15px; margin-bottom:10px; background:#fff; padding:4px; border:1px solid #ccc; border-radius:4px;'>";
            html += "<input type='color' class='gb_c' data-idx='"+i+"' value='"+c+"' style='width:30px; height:30px; border:none; padding:0; cursor:pointer; background:transparent;'>";
            if (builderColors.length > 2) {
                html += "<button type='button' class='btn btn-default btn-xs gb_del' data-idx='"+i+"' title='" + uecookie_trans.delete_color + "' style='color:#d9534f; padding:4px 8px;'><i class='icon-trash'></i></button>";
            }
            html += "</div>";
        });
        $("#gb_colors").html(html);

        $("#gb_colors input.mColorPicker").each(function() {
            $(this).attr("type", "color").removeClass("mColorPicker mColorPickerInput").css({"color": "inherit", "background-color": "transparent"});
            $(this).siblings(".mColorPickerTrigger").remove();
        });
    }

    function parseAndSetGradient(val) {
        if (!val || val.indexOf('gradient') === -1) return;

        var type = val.indexOf('radial') !== -1 ? 'radial-gradient' : 'linear-gradient';
        $("#gb_type").val(type);

        var contentMatch = val.match(/\(([^,]+),/);
        var dir = "";
        if (contentMatch) {
            dir = contentMatch[1].trim();
        }

        if (type === 'radial-gradient' && (dir.indexOf('to ') !== -1 || dir.indexOf('deg') !== -1)) {
            dir = 'circle at center';
        } else if (type === 'linear-gradient' && (dir.indexOf('at ') !== -1 || dir.indexOf('circle') !== -1 || dir.indexOf('ellipse') !== -1)) {
            dir = 'to right';
        }

        updateDirOptions(false);

        if ($("#gb_dir option[value='" + dir + "']").length > 0) {
            $("#gb_dir").val(dir);
        } else {
            $("#gb_dir").prop("selectedIndex", 0);
        }

        var extracted = val.match(/#[a-fA-F0-9]{3,6}|rgba?\([^)]+\)/g);
        if (extracted && extracted.length >= 2) {
            builderColors = extracted;
            renderColorInputs();
        }

        updateGradient();
    }

    function updateDirOptions(triggerUpdate) {
        var type = $("#gb_type").val();
        var $dir = $("#gb_dir");
        var oldVal = $dir.val();
        $dir.empty();

        if (type === 'linear-gradient') {
            $dir.append('<option value="to right">' + uecookie_trans.to_right + '</option>');
            $dir.append('<option value="to bottom">' + uecookie_trans.to_bottom + '</option>');
            $dir.append('<option value="45deg">' + uecookie_trans.diag + '</option>');
            $dir.append('<option value="135deg">' + uecookie_trans.diag_rev + '</option>');

            if (!oldVal || oldVal.indexOf('at ') !== -1 || oldVal.indexOf('circle') !== -1 || oldVal.indexOf('ellipse') !== -1) {
                $dir.val("to right");
            } else {
                $dir.val(oldVal);
            }
        } else {
            $dir.append('<option value="circle at center">' + uecookie_trans.circle_center + '</option>');
            $dir.append('<option value="ellipse at center">' + uecookie_trans.ellipse_center + '</option>');
            $dir.append('<option value="circle at top">' + uecookie_trans.circle_top + '</option>');
            $dir.append('<option value="circle at bottom">' + uecookie_trans.circle_bottom + '</option>');

            if (!oldVal || oldVal.indexOf('to ') !== -1 || oldVal.indexOf('deg') !== -1) {
                $dir.val("circle at center");
            } else {
                $dir.val(oldVal);
            }
        }

        if (!$dir.val()) { $dir.prop("selectedIndex", 0); }

        if (triggerUpdate !== false) updateGradient();
    }

    function initGradientBuilder() {
        var $gradientTarget = $("input[name='uecookie_bg_gradient']");
        if($gradientTarget.length > 0) {
            var builderHtml = "<div id='grad_builder' style='margin-top:10px; padding:15px; border:1px solid #d3d8db; background:#f5f8f9; border-radius:3px;'>" +
                "<h4 style='margin-top:0; margin-bottom:15px; font-weight:bold; color:#2e5e86;'>" + uecookie_trans.adv_gradient + "</h4>" +
                "<div style='display:flex; gap:10px; margin-bottom:15px;'>" +
                "<div style='flex:1;'><label class='small' style='display:block;'>" + uecookie_trans.type + "</label><select id='gb_type' class='form-control input-sm'><option value='linear-gradient'>" + uecookie_trans.linear + "</option><option value='radial-gradient'>" + uecookie_trans.radial + "</option></select></div>" +
                "<div style='flex:1;'><label class='small' style='display:block;'>" + uecookie_trans.dir_shape + "</label><select id='gb_dir' class='form-control input-sm'></select></div>" +
                "</div>" +
                "<label class='small' style='display:block;'>" + uecookie_trans.grad_colors + "</label>" +
                "<div id='gb_colors' style='display:flex; flex-wrap:wrap; min-height: 40px;'></div>" +
                "<button type='button' id='gb_add_color' class='btn btn-default btn-sm' style='margin-bottom:15px;'><i class='icon-plus'></i> " + uecookie_trans.add_color + "</button>" +
                "<div id='gb_preview' style='height:45px; border:1px solid #ccc; margin-top:5px; border-radius:4px; box-shadow:inset 0 1px 3px rgba(0,0,0,0.1); transition: background 0.2s;'></div>" +
                "</div>";

            $gradientTarget.after(builderHtml);

            $("#gb_type").off("change").on("change", function() { updateDirOptions(true); });
            $("#gb_dir").off("change").on("change", function() { updateGradient(); });

            updateDirOptions(false);

            $(document).on("change", ".gb_c", function(){
                builderColors[$(this).data("idx")] = $(this).val();
                updateGradient();
            });

            $(document).off("click", ".gb_del").on("click", ".gb_del", function(e) {
                e.preventDefault();
                var idx = $(this).data("idx");
                if (builderColors.length > 2) {
                    builderColors.splice(idx, 1);
                    renderColorInputs();
                    updateGradient();
                }
            });

            $("#gb_add_color").off('click').on('click', function(){
                builderColors.push("#ffffff");
                renderColorInputs();
                updateGradient();
            });

            setTimeout(function() {
                var currentVal = $gradientTarget.val();
                if (currentVal && currentVal.indexOf('gradient') !== -1) {
                    parseAndSetGradient(currentVal);
                } else {
                    renderColorInputs();
                    if($gradientTarget.val()) $("#gb_preview").css("background", $gradientTarget.val());
                }
            }, 250);
        }
    }

    // --- Sliders Helper ---
    function createSlider($input, min, max, step, suffix) {
        if($input.length === 0) return;
        var currentVal = parseFloat($input.val()) || min;
        var $container = $("<div style='margin-top:10px; display:flex; align-items:center; gap:15px; border:1px solid #d3d8db; padding:10px; background:#fff; border-radius:3px;'></div>");
        var $range = $("<input type='range' min='"+min+"' max='"+max+"' step='"+step+"' value='"+currentVal+"' style='flex-grow:1; cursor:pointer;'>");
        var $display = $("<span style='font-weight:bold; min-width:50px; text-align:right;'></span>");
        function updateDisplay(v) { $display.text(v + suffix); }
        updateDisplay(currentVal); $container.append($range).append($display); $input.after($container);
        $range.on("input change", function(){
            var val = $(this).val();
            $input.val(val).trigger("change");
            updateDisplay(val);
        });
        $input.on("change", function(){
            var val = $(this).val();
            if(!isNaN(parseFloat(val))) {
                $range.val(val);
                updateDisplay(val);
            }
        });
    }

    // --- Initialization ---

    $("#ue-preview-container").css({
        "background-image": "url('" + uecookie_bg_img + "')",
        "background-repeat": "no-repeat",
        "background-position": "center top"
    });

    var proOptions = [3, 4, 5, 6, 7, 8, 9];
    $.each(proOptions, function(index, value) {
        $('select[name="uecookie_position"] option[value="' + value + '"]').attr('disabled', 'disabled').css('color', '#999');
    });

    createSlider($("input[name='uecookie_opacity']"), 0.05, 1, 0.05, "");
    createSlider($("input[name='uecookie_btn_size']"), 8, 22, 1, "px");
    createSlider($("input[name='uecookie_btn_pad_v']"), 0, 15, 1, "px");
    createSlider($("input[name='uecookie_btn_pad_h']"), 0, 15, 1, "px");

    // Syncing specific listeners (Prioritize direct Main Form element IDs)
    function attachQCEvent(qcId, mainName) {
        $("#" + qcId).on("input change", function() {
            var val = $(this).val();
            var $main = $("#" + mainName);
            if ($main.length) {
                $main.val(val).trigger("change");
            } else {
                $("[name='" + mainName + "']").val(val).trigger("change");
            }
            updatePreview();
        });
    }

    attachQCEvent("qc_bg", "uecookie_bg");
    attachQCEvent("qc_text", "uecookie_text_color");
    attachQCEvent("qc_shadow", "uecookie_shadow");
    attachQCEvent("qc_opacity", "uecookie_opacity");
    attachQCEvent("qc_pos", "uecookie_position");
    attachQCEvent("qc_close_pos", "uecookie_close_pos");
    attachQCEvent("qc_btn_size", "uecookie_btn_size");
    attachQCEvent("qc_pad_v", "uecookie_btn_pad_v");
    attachQCEvent("qc_pad_h", "uecookie_btn_pad_h");
    attachQCEvent("qc_usex", "uecookie_usex");

    $("#qc_save").click(function() { $("button[name='submitUeCookie']").first().click(); });

    $("#ue-clear-filters").click(function() { selectedTags = []; renderTags(); renderPresets(); });
    $(document).on("input change", "input, select", function(){ updatePreview(); });

    initGradientBuilder();
    renderTags();
    renderPresets();
    syncQC();
    updatePreview();
});