<?php
/**
 * PrestaShop module created by VEKIA, a guy from official PrestaShop community ;-)
 *
 * @author    VEKIA PL MILOSZ MYZSCZUK VATEU: PL9730945634
 * @copyright 2010-2026 VEKIA
 * @license   This program is not free software and you can't resell and redistribute it
 * * CONTACT WITH DEVELOPER
 * support@mypresta.eu
 */

if (!defined('_PS_VERSION_')) {
    exit;
}

/**
 * Class uecookie
 * Main class of the module responsible for Cookies Law notification
 */
class uecookie extends Module
{
    /** @var string $mkey Unique key for the module */
    public $mkey;

    /** @var string $mypresta_link Official link to the module page */
    public $mypresta_link;

    /**
     * uecookie constructor.
     * Initializes module basic data and checks for updates.
     */
    public function __construct()
    {
        $this->name = 'uecookie';
        $this->tab = 'front_office_features';
        $this->author = 'MyPresta.eu';
        $this->version = '2.0.0';
        $this->module_key = '98954d996259885532adabb50f129a9d';
        $this->mypresta_link = 'https://mypresta.eu/modules/front-office-features/european-union-cookie-law.html';
        $this->bootstrap = true;

        parent::__construct();

        $this->displayName = $this->l('European Union Cookies Law (Pro)');
        $this->description = $this->l('Displays professional information about Cookies with advanced styling, Live Preview and update checker.');

        // This function is responsible for checking if a new version is available on MyPresta servers
        $this->checkforupdates();
    }

    /**
     * Module installation process.
     * Sets default configuration values and registers necessary hooks.
     * @return bool
     */
    public function install()
    {
        $languages = Language::getLanguages(false);
        $text_multilang = array();
        $btn_text_multilang = array();

        foreach ($languages as $lang) {
            $text_multilang[$lang['id_lang']] = $this->l('This shop uses cookies and other technologies so that we can improve your experience on our sites.');
            $btn_text_multilang[$lang['id_lang']] = $this->l('close');
        }

        return parent::install() &&
            $this->registerHook('displayHeader') &&
            $this->registerHook('displayFooter') &&
            Configuration::updateValue('update_' . $this->name, '0') &&
            Configuration::updateValue('uecookie_text', $text_multilang, true) &&
            Configuration::updateValue('uecookie_btn_text', $btn_text_multilang, true) &&
            Configuration::updateValue('uecookie_bg', '#000000') &&
            Configuration::updateValue('uecookie_text_color', '#ffffff') &&
            Configuration::updateValue('uecookie_opacity', '0.90') &&
            Configuration::updateValue('uecookie_position', 1) &&
            Configuration::updateValue('uecookie_usex', 0) &&
            Configuration::updateValue('uecookie_close_anim', 0) &&
            Configuration::updateValue('uecookie_close_pos', 2) &&
            Configuration::updateValue('uecookie_btn_size', 11) &&
            Configuration::updateValue('uecookie_btn_pad_v', 5) &&
            Configuration::updateValue('uecookie_btn_pad_h', 15) &&
            Configuration::updateValue('uecookie_shadow', '#FFFFFF') &&
            Configuration::updateValue('uecookie_bg_gradient', '');
    }

    /**
     * Helper to verify if the module environment is consistent.
     * @return bool
     */
    public function inconsistency()
    {
        return true;
    }

    /**
     * Returns PrestaShop version part (major or minor).
     * Necessary for cross-version compatibility (1.6, 1.7, 8, 9).
     * @param int $part
     * @return int
     */
    public function psversion($part = 1)
    {
        $version = _PS_VERSION_;
        $exp = explode(".", $version);
        if ($exp[0] == '1') {
            return (isset($exp[$part])) ? (int)$exp[$part] : 0;
        } else {
            // New versioning scheme for PrestaShop 8+
            if ($part == 1) return (int)$exp[0];
            return (isset($exp[$part - 1])) ? (int)$exp[$part - 1] : 0;
        }
    }

    /**
     * Generates advertising banner from dev.addons.ovh
     * @return string HTML iframe
     */
    public function adds()
    {
        return '<div style="display:block; clear:both; margin-bottom:20px;">
             <iframe src="//dev.addons.ovh/modules.html?module='.$this->name.'" width="100%" height="150" border="0" style="border:none;"></iframe>
          </div>';
    }

    /**
     * Renders Live Preview section structure.
     * Logic is handled in views/js/scripts.js.
     * @return string HTML
     */
    public function renderLivePreview()
    {
        return '
        <div class="panel" style="margin-bottom: 20px;">
            <div class="panel-heading"><i class="icon-eye"></i> ' . $this->l('Live Preview & Quick Configuration') . '</div>
            <div class="row">
                <!-- Left Sidebar: Presets & Filters -->
                <div class="col-md-3" style="border-right: 1px solid #eee;">
                    <h4 style="margin-top:0;">' . $this->l('Design Presets') . '</h4>
                    <div class="list-group" id="ue-presets-list" style="max-height: 200px; overflow-y: auto; margin-bottom: 10px; border: 1px solid #ddd; border-radius: 4px;"></div>
                    
                    <!-- PRO Version Info Box -->
                    <div class="alert-info" style="margin-bottom: 15px; font-size: 11px; border-left: 4px solid #2e5e86; background-color: #f0f8ff; padding: 12px;">
                        <p style="margin-bottom: 5px;"><strong>' . $this->l('Need more layout inspiration?') . '</strong></p>
                        <p style="line-height: 1.4; color: #555;">
                            ' . $this->l('Upgrade to PRO to unlock over 100+ stunning built-in designs. Plus, get instant access to our "Community Patterns" — an exclusive library of layouts added by creative designers worldwide.') . '
                        </p>
                        <a href="https://mypresta.eu/modules/front-office-features/european-union-cookie-law-pro.html" target="_blank" class="btn btn-primary btn-xs" style="margin-top: 10px; width: 100%; font-weight: bold; text-transform: uppercase;">
                            <i class="icon-star"></i> ' . $this->l('Get PRO & Community Access') . '
                        </a>
                    </div>

                    <!-- Tags Filter -->
                    <div id="ue-filter-section" style="background: #f9f9f9; padding: 10px; border-radius: 4px; border: 1px solid #ddd;">
                        <h5 style="margin-top:0; font-weight: bold;"><i class="icon-filter"></i> ' . $this->l('Filter by tags') . ':</h5>
                        <div id="ue-tags-container" style="display: flex; flex-wrap: wrap; gap: 5px;"></div>
                        <button type="button" id="ue-clear-filters" class="btn btn-default btn-xs" style="margin-top: 10px; width: 100%;">' . $this->l('Clear filters') . '</button>
                    </div>
                </div>

                <!-- Main Content: Preview & Quick Config -->
                <div class="col-md-9">
                    <div class="row">
                        <!-- Visual Simulation -->
                        <div class="col-md-7">
                            <h4 style="margin-top:0;">' . $this->l('Visual Preview') . '</h4>
                               <div id="ue-preview-container" style="padding: 80px 20px; border: 1px dashed #ccc; position: relative; overflow: hidden; border-radius: 5px; min-height: 400px; display: flex; align-items: center; justify-content: center;">
                                <div id="ue-preview-bar" style="position: absolute; left: 0; width: 100%; padding: 15px; display: flex; align-items: center; box-sizing: border-box; transition: all 0.3s ease; min-height: 60px;">
                                    <div id="ue-preview-text" style="flex: 1; font-size: 13px;">' . $this->l('Sample cookie information text goes here...') . '</div>
                                    <div id="ue-preview-btn-wrap" style="padding: 0 15px; display: flex; align-items: center; justify-content: center;">
                                        <span id="ue-preview-btn" style="border: 1px solid; border-radius: 4px; font-weight: bold; cursor: pointer; transition: opacity 0.2s; display: inline-block;">' . $this->l('close') . '</span>
                                        <span id="ue-preview-x" style="font-size: 24px; cursor: pointer; display:none; transition: opacity 0.2s; line-height: 0.8;">&times;</span>
                                    </div>
                                </div>
                            </div>
                        </div>

                        <!-- Quick Configuration Fields -->
                        <div class="col-md-5">
                            <h4 style="margin-top:0;">' . $this->l('Quick Config') . '</h4>
                            <div class="well well-sm" style="background: #fff; border-radius: 4px; padding: 10px;">
                                <div class="row">
                                    <div class="col-xs-6">
                                        <label class="control-label small">' . $this->l('Background') . '</label>
                                        <input type="color" id="qc_bg" class="form-control input-sm" style="height: 25px; padding: 2px; margin-bottom: 8px;">
                                    </div>
                                    <div class="col-xs-6">
                                        <label class="control-label small">' . $this->l('Text Color') . '</label>
                                        <input type="color" id="qc_text" class="form-control input-sm" style="height: 25px; padding: 2px; margin-bottom: 8px;">
                                    </div>
                                </div>
                                <div class="row">
                                    <div class="col-xs-6">
                                        <label class="control-label small">' . $this->l('Shadow Color') . '</label>
                                        <input type="color" id="qc_shadow" class="form-control input-sm" style="height: 25px; padding: 2px; margin-bottom: 8px;">
                                    </div>
                                    <div class="col-xs-6">
                                        <label class="control-label small">' . $this->l('Opacity') . '</label>
                                        <input type="range" id="qc_opacity" min="0.05" max="1" step="0.05" style="width: 100%; margin-top: 5px;">
                                    </div>
                                </div>
                                <div class="row">
                                    <div class="col-xs-6">
                                        <label class="control-label small">' . $this->l('Position') . '</label>
                                        <select id="qc_pos" class="form-control input-sm" style="margin-bottom: 8px;">
                                            <option value="1">' . $this->l('Top') . '</option>
                                            <option value="2">' . $this->l('Bottom') . '</option>
                                        </select>
                                    </div>
                                    <div class="col-xs-6">
                                        <label class="control-label small">' . $this->l('Btn Align') . '</label>
                                        <select id="qc_close_pos" class="form-control input-sm" style="margin-bottom: 8px;">
                                            <option value="1">' . $this->l('Left') . '</option>
                                            <option value="2">' . $this->l('Right') . '</option>
                                            <option value="3">' . $this->l('Center') . '</option>
                                        </select>
                                    </div>
                                </div>
                                <div class="row">
                                    <div class="col-xs-6">
                                        <label class="control-label small">' . $this->l('Btn Style') . '</label>
                                        <select id="qc_usex" class="form-control input-sm" style="margin-bottom: 8px;">
                                            <option value="0">' . $this->l('Text button') . '</option>
                                            <option value="1">' . $this->l('Icon [X]') . '</option>
                                        </select>
                                    </div>
                                    <div class="col-xs-6">
                                        <label class="control-label small">' . $this->l('Btn Size') . '</label>
                                        <input type="range" id="qc_btn_size" min="8" max="22" step="1" style="width: 100%; margin-top: 5px;">
                                    </div>
                                </div>
                                <div class="row">
                                    <div class="col-xs-6">
                                        <label class="control-label small">' . $this->l('Padding V') . '</label>
                                        <input type="range" id="qc_pad_v" min="0" max="15" step="1" style="width: 100%; margin-top: 5px;">
                                    </div>
                                    <div class="col-xs-6">
                                        <label class="control-label small">' . $this->l('Padding H') . '</label>
                                        <input type="range" id="qc_pad_h" min="0" max="15" step="1" style="width: 100%; margin-top: 5px;">
                                    </div>
                                </div>
                                <hr style="margin: 10px 0;">
                                <button type="button" id="qc_save" class="btn btn-success btn-block" style="font-weight: bold;">
                                    <i class="icon-save"></i> ' . $this->l('Save All Settings') . '
                                </button>
                            </div>
                        </div>
                    </div>
                    <style id="ue-preview-force-styles"></style>
                </div>
            </div>
        </div>';
    }

    /**
     * Renders Gradient Builder container. HTML only.
     * @return string
     */
    public function renderCustomJS()
    {
        return '<div id="ue-gradient-builder-placeholder"></div>';
    }

    /**
     * FULL ORIGINAL UPDATE CHECKER MECHANISM.
     * This method is critical for checking module updates from MyPresta.eu servers.
     * It handles notification display and manual update triggers.
     * @param int $display_msg Toggle to show status message
     * @param int $form Toggle to show the full update configuration panel
     * @return string HTML content for the update panel
     */
    public function checkforupdates($display_msg = 0, $form = 0)
    {
        $this->mkey = "nlc";
        if (@file_exists('../modules/' . $this->name . '/key.php')) {
            @require_once('../modules/' . $this->name . '/key.php');
        } else {
            if (@file_exists(dirname(__FILE__) . $this->name . '/key.php')) {
                @require_once(dirname(__FILE__) . $this->name . '/key.php');
            } else {
                if (@file_exists('modules/' . $this->name . '/key.php')) {
                    @require_once('modules/' . $this->name . '/key.php');
                }
            }
        }

        if ($form == 1) {
            return '
            <div class="panel" id="fieldset_myprestaupdates" style="margin-top:20px;">
            ' . ($this->psversion() >= 6 ? '<div class="panel-heading"><i class="icon-wrench"></i> ' . $this->l('MyPresta updates') . '</div>' : '') . '
			<div class="form-wrapper" style="padding:20px!important;">
                <div id="module_block_settings">
                    <fieldset id="fieldset_module_block_settings">
                         ' . ($this->psversion() == 5 ? '<legend style="">' . $this->l('MyPresta updates') . '</legend>' : '') . '
                        <form action="' . $_SERVER['REQUEST_URI'] . '" method="post">
                            <label>' . $this->l('Check updates') . '</label>
                            <div class="margin-form">' . (Tools::isSubmit('submit_settings_updates_now') ? ($this->inconsistency(0) ? '' : '') . $this->checkforupdates(1) : '') . '
                                <button style="margin: 0px; top: -3px; position: relative;" type="submit" name="submit_settings_updates_now" class="button btn btn-default" />
                                <i class="process-icon-update"></i>
                                ' . $this->l('Check now') . '
                                </button>
                            </div>
                            <label>' . $this->l('Updates notifications') . '</label>
                            <div class="margin-form">
                                <select name="mypresta_updates">
                                    <option value="-">' . $this->l('-- select --') . '</option>
                                    <option value="1" ' . ((int)(Configuration::get('mypresta_updates') == 1) ? 'selected="selected"' : '') . '>' . $this->l('Enable') . '</option>
                                    <option value="0" ' . ((int)(Configuration::get('mypresta_updates') == 0) ? 'selected="selected"' : '') . '>' . $this->l('Disable') . '</option>
                                </select>
                                <p class="clear">' . $this->l('Turn this option on if you want to check MyPresta.eu for module updates automatically. This option will display notification about new versions of this addon.') . '</p>
                            </div>
                            <label>' . $this->l('Module page') . '</label>
                            <div class="margin-form">
                                <a style="font-size:14px;" href="' . $this->mypresta_link . '" target="_blank">' . $this->displayName . '</a>
                                <p class="clear">' . $this->l('This is direct link to official addon page, where you can read about changes in the module (changelog)') . '</p>
                            </div>
                            <div class="panel-footer">
                                <button type="submit" name="submit_settings_updates" class="button btn btn-default pull-right" />
                                <i class="process-icon-save"></i>
                                ' . $this->l('Save') . '
                                </button>
                            </div>
                        </form>
                    </fieldset>
                    <style>
                    #fieldset_myprestaupdates { display:block;clear:both; float:inherit!important; }
                    </style>
                </div>
            </div>
            </div>';
        } else {
            if (defined('_PS_ADMIN_DIR_')) {
                if (Tools::isSubmit('submit_settings_updates')) {
                    Configuration::updateValue('mypresta_updates', Tools::getValue('mypresta_updates'));
                }
                if (Configuration::get('mypresta_updates') != 0) {
                    if (Configuration::get('update_' . $this->name) < (date("U") - 259200)) {
                        $actual_version = uecookieUpdate::verify($this->name, (isset($this->mkey) ? $this->mkey : 'nokey'), $this->version);
                    }
                    if (uecookieUpdate::version($this->version) < uecookieUpdate::version(Configuration::get('updatev_' . $this->name))) {
                        $this->context->controller->warnings[] = '<strong>' . $this->displayName . '</strong>: ' . $this->l('New version available, check http://MyPresta.eu') . ' <a href="' . $this->mypresta_link . '">' . $this->l('More details in changelog') . '</a>';
                        $this->warning = isset($this->context->controller->warnings[0]) ? $this->context->controller->warnings[0] : '';
                    }
                } else {
                    if (Configuration::get('update_' . $this->name) < (date("U") - 259200)) {
                        $actual_version = uecookieUpdate::verify($this->name, (isset($this->mkey) ? $this->mkey : 'nokey'), $this->version);
                    }
                }
                if ($display_msg == 1) {
                    if (uecookieUpdate::version($this->version) < uecookieUpdate::version(Configuration::get('updatev_' . $this->name))) {
                        return "<span style='color:red; font-weight:bold; font-size:16px; margin-right:10px;'>" . $this->l('New version available!') . "</span>";
                    } else {
                        return "<span style='color:green; font-weight:bold; font-size:16px; margin-right:10px;'>" . $this->l('Module is up to date!') . "</span>";
                    }
                }
            }
        }
    }

    /**
     * Module configuration page logic.
     * Manages settings persistence and displays content panels.
     * @return string
     */
    public function getContent()
    {
        // Add assets according to PrestaShop guidelines
        $this->context->controller->addJS($this->_path . 'views/js/scripts.js');

        // Pass dynamic data and translations to JS
        Media::addJsDef(array(
            'uecookie_bg_img' => Context::getContext()->shop->getBaseUrl() . 'modules/uecookie/views/img/bg.png',
            'uecookie_trans' => array(
                'adv_gradient' => $this->l('Advanced Gradient Builder'),
                'linear' => $this->l('Linear'),
                'radial' => $this->l('Radial'),
                'to_right' => $this->l('To Right'),
                'to_bottom' => $this->l('To Bottom'),
                'add_color' => $this->l('Add color'),
                'filter_tags' => $this->l('Filter by tags'),
                'clear_filters' => $this->l('Clear filters'),
                'type' => $this->l('Type'),
                'dir_shape' => $this->l('Direction / Shape'),
                'grad_colors' => $this->l('Gradient colors'),
                'delete_color' => $this->l('Delete color'),
                'diag' => $this->l('Diagonal (45deg)'),
                'diag_rev' => $this->l('Diagonal Reverse'),
                'circle_center' => $this->l('Circle Center'),
                'ellipse_center' => $this->l('Ellipse Center'),
                'circle_top' => $this->l('Circle Top'),
                'circle_bottom' => $this->l('Circle Bottom')
            )
        ));

        $output = '';
        if (Tools::isSubmit('submitUeCookie')) {
            $languages = Language::getLanguages(false);
            $uecookie_text = array();
            $uecookie_btn_text = array();
            foreach ($languages as $lang) {
                $uecookie_text[$lang['id_lang']] = Tools::getValue('uecookie_text_' . $lang['id_lang']);
                $uecookie_btn_text[$lang['id_lang']] = Tools::getValue('uecookie_btn_text_' . $lang['id_lang']);
            }
            Configuration::updateValue('uecookie_text', $uecookie_text, true);
            Configuration::updateValue('uecookie_btn_text', $uecookie_btn_text, true);
            Configuration::updateValue('uecookie_bg', Tools::getValue('uecookie_bg'));
            Configuration::updateValue('uecookie_text_color', Tools::getValue('uecookie_text_color'));
            Configuration::updateValue('uecookie_bg_gradient', Tools::getValue('uecookie_bg_gradient'), true);
            Configuration::updateValue('uecookie_position', (int)Tools::getValue('uecookie_position'));
            Configuration::updateValue('uecookie_opacity', Tools::getValue('uecookie_opacity'));
            Configuration::updateValue('uecookie_usex', (int)Tools::getValue('uecookie_usex'));
            Configuration::updateValue('uecookie_close_anim', (int)Tools::getValue('uecookie_close_anim'));
            Configuration::updateValue('uecookie_close_pos', (int)Tools::getValue('uecookie_close_pos'));
            Configuration::updateValue('uecookie_btn_size', (int)Tools::getValue('uecookie_btn_size'));
            Configuration::updateValue('uecookie_btn_pad_v', (int)Tools::getValue('uecookie_btn_pad_v'));
            Configuration::updateValue('uecookie_btn_pad_h', (int)Tools::getValue('uecookie_btn_pad_h'));
            Configuration::updateValue('uecookie_shadow', Tools::getValue('uecookie_shadow'));
            $output .= $this->displayConfirmation($this->l('Settings updated successfully.'));
        }
        return $this->adds() . $this->renderLivePreview() . $this->renderForm() . $this->renderCustomJS() . $this->checkforupdates(0, 1);
    }

    /**
     * Build the configuration form using HelperForm.
     * Defines all input fields and their behaviors.
     * @return string HTML Form
     */
    public function renderForm()
    {
        $fields_form = array(
            'form' => array(
                'legend' => array('title' => $this->l('UE Cookie Law Settings'), 'icon' => 'icon-cogs'),
                'input' => array(
                    array(
                        'type' => 'textarea',
                        'label' => $this->l('Cookie information text'),
                        'name' => 'uecookie_text',
                        'lang' => true,
                        'autoload_rte' => true,
                        'desc' => $this->l('Enter the text that will inform your customers about the use of cookies. Standard: This shop uses cookies and other technologies so that we can improve your experience on our sites.')
                    ),
                    array(
                        'type' => 'text',
                        'label' => $this->l('Button text'),
                        'name' => 'uecookie_btn_text',
                        'lang' => true,
                        'desc' => $this->l('Define the label of the acceptance button. Standard value: close.')
                    ),
                    array(
                        'type' => 'text',
                        'label' => $this->l('Button font size'),
                        'name' => 'uecookie_btn_size',
                        'class' => 'fixed-width-sm',
                        'desc' => $this->l('Set the font size for the button text in pixels. Standard value: 11px.')
                    ),
                    array(
                        'type' => 'text',
                        'label' => $this->l('Button vertical padding'),
                        'name' => 'uecookie_btn_pad_v',
                        'class' => 'fixed-width-sm',
                        'desc' => $this->l('Adjust the vertical spacing inside the button. Standard value: 5px.')
                    ),
                    array(
                        'type' => 'text',
                        'label' => $this->l('Button horizontal padding'),
                        'name' => 'uecookie_btn_pad_h',
                        'class' => 'fixed-width-sm',
                        'desc' => $this->l('Adjust the horizontal spacing inside the button. Standard value: 15px.')
                    ),
                    array(
                        'type' => 'select',
                        'label' => $this->l('Bar position'),
                        'name' => 'uecookie_position',
                        'options' => array(
                            'query' => array(
                                array('id' => 1, 'name' => $this->l('Top of the page')),
                                array('id' => 2, 'name' => $this->l('Bottom of the page')),
                                array('id' => 3, 'name' => $this->l('Middle of window (available in PRO version)')),
                                array('id' => 4, 'name' => $this->l('Top-left corner (available in PRO version)')),
                                array('id' => 5, 'name' => $this->l('Top-right corner (available in PRO version)')),
                                array('id' => 6, 'name' => $this->l('Bottom-left corner (available in PRO version)')),
                                array('id' => 7, 'name' => $this->l('Bottom-right corner (available in PRO version)')),
                                array('id' => 8, 'name' => $this->l('Top-center (available in PRO version)')),
                                array('id' => 9, 'name' => $this->l('Bottom-center (available in PRO version)'))
                            ),
                            'id' => 'id',
                            'name' => 'name'
                        ),
                        'desc' => $this->l('Choose whether the notification bar appears at the top or bottom of the screen. Standard value: Top of the page.')
                    ),
                    array(
                        'type' => 'select',
                        'label' => $this->l('Close button position'),
                        'name' => 'uecookie_close_pos',
                        'options' => array(
                            'query' => array(
                                array('id' => 1, 'name' => $this->l('Left')),
                                array('id' => 2, 'name' => $this->l('Right')),
                                array('id' => 3, 'name' => $this->l('Center'))
                            ),
                            'id' => 'id',
                            'name' => 'name'
                        ),
                        'desc' => $this->l('Set the horizontal alignment of the close button. Standard value: Right.')
                    ),
                    array(
                        'type' => 'color',
                        'label' => $this->l('Background color'),
                        'name' => 'uecookie_bg',
                        'desc' => $this->l('Choose the primary background color for the cookie bar. Standard value: #000000.')
                    ),
                    array(
                        'type' => 'text',
                        'label' => $this->l('Background gradient (optional)'),
                        'name' => 'uecookie_bg_gradient',
                        'desc' => $this->l('Paste custom CSS gradient code here to override the background color. Standard value: empty.')
                    ),
                    array(
                        'type' => 'color',
                        'label' => $this->l('Text color'),
                        'name' => 'uecookie_text_color',
                        'desc' => $this->l('This color will be strictly enforced on all text elements inside the bar. Standard value: #ffffff.')
                    ),
                    array(
                        'type' => 'color',
                        'label' => $this->l('Shadow color'),
                        'name' => 'uecookie_shadow',
                        'desc' => $this->l('Set the color for the outer glow or shadow of the bar. Standard value: #FFFFFF.')
                    ),
                    array(
                        'type' => 'text',
                        'label' => $this->l('Bar opacity'),
                        'name' => 'uecookie_opacity',
                        'class' => 'fixed-width-sm',
                        'desc' => $this->l('Adjust transparency between 0.05 (invisible) and 1.00 (opaque). Standard value: 0.90.')
                    ),
                    array(
                        'type' => 'select',
                        'label' => $this->l('Close button style'),
                        'name' => 'uecookie_usex',
                        'options' => array(
                            'query' => array(
                                array('id' => 0, 'name' => $this->l('Text button')),
                                array('id' => 1, 'name' => $this->l('Icon [X]'))
                            ),
                            'id' => 'id',
                            'name' => 'name'
                        ),
                        'desc' => $this->l('Select the visual style of the close trigger. Standard value: Text button.')
                    ),
                    array(
                        'type' => 'select',
                        'label' => $this->l('Close animation style'),
                        'name' => 'uecookie_close_anim',
                        'options' => array(
                            'query' => array(
                                array('id' => 0, 'name' => $this->l('Slide out')),
                                array('id' => 1, 'name' => $this->l('Fade out'))
                            ),
                            'id' => 'id',
                            'name' => 'name'
                        ),
                        'desc' => $this->l('Select the animation used when the user clicks the close button. Standard value: Slide out.')
                    ),
                ),
                'submit' => array('title' => $this->l('Save settings'))
            ),
        );
        $helper = new HelperForm();
        $helper->module = $this;
        $helper->default_form_language = (int)Configuration::get('PS_LANG_DEFAULT');
        $helper->allow_employee_form_lang = Configuration::get('PS_BO_ALLOW_EMPLOYEE_FORM_LANG') ? Configuration::get('PS_BO_ALLOW_EMPLOYEE_FORM_LANG') : 0;
        $helper->submit_action = 'submitUeCookie';
        $helper->currentIndex = $this->context->link->getAdminLink('AdminModules', false) . '&configure=' . $this->name;
        $helper->token = Tools::getAdminTokenLite('AdminModules');
        $helper->tpl_vars = array('fields_value' => $this->getConfigFieldsValues(), 'languages' => $this->context->controller->getLanguages(), 'id_language' => $this->context->language->id);
        return $helper->generateForm(array($fields_form));
    }

    /**
     * Maps database configuration to Form values.
     * @return array
     */
    public function getConfigFieldsValues()
    {
        $languages = Language::getLanguages(false);
        $fields = array();
        foreach ($languages as $lang) {
            $fields['uecookie_text'][$lang['id_lang']] = Configuration::get('uecookie_text', $lang['id_lang']);
            $fields['uecookie_btn_text'][$lang['id_lang']] = Configuration::get('uecookie_btn_text', $lang['id_lang']);
        }
        $fields['uecookie_bg'] = Configuration::get('uecookie_bg');
        $fields['uecookie_text_color'] = Configuration::get('uecookie_text_color');
        $fields['uecookie_bg_gradient'] = Configuration::get('uecookie_bg_gradient');
        $fields['uecookie_position'] = Configuration::get('uecookie_position');
        $fields['uecookie_opacity'] = Configuration::get('uecookie_opacity');
        $fields['uecookie_usex'] = Configuration::get('uecookie_usex');
        $fields['uecookie_close_anim'] = Configuration::get('uecookie_close_anim');
        $fields['uecookie_close_pos'] = Configuration::get('uecookie_close_pos');
        $fields['uecookie_btn_size'] = Configuration::get('uecookie_btn_size');
        $fields['uecookie_btn_pad_v'] = Configuration::get('uecookie_btn_pad_v');
        $fields['uecookie_btn_pad_h'] = Configuration::get('uecookie_btn_pad_h');
        $fields['uecookie_shadow'] = Configuration::get('uecookie_shadow');
        return $fields;
    }

    /**
     * Footer hook. Responsible for rendering the cookie bar on front-office.
     * @param array $params
     * @return string HTML
     */
    public function hookDisplayFooter($params) {
        if (isset($_COOKIE['cookie_ue'])) return;
        $id_lang = (int)$this->context->language->id;
        $vars = array(
            'ue_text' => Configuration::get('uecookie_text', $id_lang),
            'ue_btn_text' => Configuration::get('uecookie_btn_text', $id_lang),
            'ue_bg' => Configuration::get('uecookie_bg'),
            'ue_text_color' => Configuration::get('uecookie_text_color'),
            'ue_gradient' => Configuration::get('uecookie_bg_gradient'),
            'ue_pos' => (int)Configuration::get('uecookie_position'),
            'ue_opacity' => Configuration::get('uecookie_opacity'),
            'ue_usex' => (int)Configuration::get('uecookie_usex'),
            'ue_anim' => (int)Configuration::get('uecookie_close_anim'),
            'ue_close_pos' => (int)Configuration::get('uecookie_close_pos'),
            'ue_btn_size' => (int)Configuration::get('uecookie_btn_size'),
            'ue_btn_pad_v' => (int)Configuration::get('uecookie_btn_pad_v'),
            'ue_btn_pad_h' => (int)Configuration::get('uecookie_btn_pad_h'),
            'ue_shadow' => Configuration::get('uecookie_shadow'),
        );
        $this->context->smarty->assign('ue_config', $vars);
        return $this->display(__FILE__, 'top.tpl');
    }
}

/**
 * Class uecookieUpdate
 * Internal class for update verification against MyPresta.eu servers.
 */
class uecookieUpdate extends uecookie
{
    /**
     * Normalizes version string to integer for comparison.
     * @param string $version
     * @return int
     */
    public static function version($version) {
        $version = (int)str_replace(".", "", $version);
        if (strlen($version) == 3) $version = (int)$version . "0";
        if (strlen($version) == 2) $version = (int)$version . "00";
        if (strlen($version) == 1) $version = (int)$version . "000";
        if (strlen($version) == 0) $version = (int)$version . "0000";
        return (int)$version;
    }

    /**
     * Encrypts string for secure transmission.
     * @param string $string
     * @return string
     */
    public static function encrypt($string) { return base64_encode($string); }

    /**
     * Checks remote server for the latest module version.
     * @param string $module
     * @param string $key
     * @param string $version
     * @return string latest version
     */
    public static function verify($module, $key, $version) {
        $actual_version = '0';
        if (ini_get("allow_url_fopen")) {
            if (function_exists("file_get_contents")) {
                $actual_version = @file_get_contents('http://dev.mypresta.eu/update/get.php?module=' . $module . "&version=" . self::encrypt($version) . "&lic=$key&u=" . self::encrypt(_PS_BASE_URL_ . __PS_BASE_URI__));
            }
        }
        Configuration::updateValue("update_" . $module, date("U"));
        Configuration::updateValue("updatev_" . $module, $actual_version);
        return $actual_version;
    }
}