{*
* PrestaShop module created by VEKIA
*}
<style>
    #cookieNotice {
        width: 100%;
        position: fixed;
        left: 0;
        z-index: 999999;
        padding: 15px 30px;
        box-sizing: border-box;
        font-family: Arial, sans-serif;
        opacity: {$ue_config.ue_opacity};
    {if $ue_config.ue_gradient}
        background: {$ue_config.ue_gradient};
    {else}
        background-color: {$ue_config.ue_bg};
    {/if}
    {if $ue_config.ue_pos == 1}
        top: 0;
        box-shadow: 0 2px 10px {$ue_config.ue_shadow};
    {else}
        bottom: 0;
        box-shadow: 0 -2px 10px {$ue_config.ue_shadow};
    {/if}

        display: flex;
        align-items: center;
        min-height: 50px;
    }

    #cookieNotice, #cookieNotice * {
        color: {$ue_config.ue_text_color} !important;
    }

    #cookieNotice p {
        margin: 0 !important;
        padding: 0 !important;
    }

    .ue-container {
        display: flex;
        align-items: center;
        justify-content: center;
        max-width: 100%;
        margin: 0 auto;
        width: 100%;
    {if $ue_config.ue_close_pos == 3}
        flex-direction: column;
        gap: 10px;
    {/if}
    }

    .ue-spacer {
        flex: 0 0 150px;
        display: {if $ue_config.ue_close_pos == 3}none{else}block{/if};
    }

    .ue-content {
        flex: 1;
        text-align: center;
        font-size: 14px;
        line-height: 1.4;
        display: flex;
        align-items: center;
        justify-content: center;
    }

    .ue-actions {
        flex: 0 0 150px;
        display: flex;
        align-items: center;
        white-space: nowrap;
    {if $ue_config.ue_close_pos == 1}
        justify-content: flex-start;
        order: -1;
    {elseif $ue_config.ue_close_pos == 2}
        justify-content: flex-end;
        order: 1;
    {else}
        justify-content: center;
        flex: 0 0 auto;
    {/if}
    }

    .ue-close-btn {
        cursor: pointer;
        /* Custom Padding */
        padding: {$ue_config.ue_btn_pad_v}px {$ue_config.ue_btn_pad_h}px;
        border: 1px solid {$ue_config.ue_text_color};
        border-radius: 4px;
        transition: opacity 0.2s;
        font-weight: bold;
        display: inline-block;
        background: transparent;
        line-height: 1;
        /* Custom Font Size */
        font-size: {$ue_config.ue_btn_size}px;
    }

    .ue-close-btn:hover, .ue-x:hover {
        opacity: 0.7 !important;
        background: transparent !important;
    }

    .ue-x {
        /* Custom Font Size (+10px offset for icon scaling) */
        font-size: {math equation="x + 10" x=$ue_config.ue_btn_size}px;
        cursor: pointer;
        line-height: 0.8;
        display: block;
        transition: opacity 0.2s;
    }

    @media (max-width: 768px) {
        #cookieNotice { padding: 15px; }
        .ue-container { flex-direction: column !important; }
        .ue-spacer { display: none; }
        .ue-actions { flex: 0 0 auto; margin-top: 10px; }
    }
</style>

<div id="cookieNotice">
    <div class="ue-container">
        {if $ue_config.ue_close_pos == 2}
            <div class="ue-spacer"></div>
        {/if}

        <div class="ue-content">
            <div style="width: 100%;">{$ue_config.ue_text nofilter}</div>
        </div>

        <div class="ue-actions">
            {if $ue_config.ue_usex}
                <span class="ue-x" onclick="closeUeNotify()">&times;</span>
            {else}
                <span class="ue-close-btn" onclick="closeUeNotify()">{$ue_config.ue_btn_text}</span>
            {/if}
        </div>

        {if $ue_config.ue_close_pos == 1}
            <div class="ue-spacer"></div>
        {/if}
    </div>
</div>

<script>
    function setcook() {
        var name = 'cookie_ue';
        var value = '1';
        var expire = new Date();
        expire.setMonth(expire.getMonth() + 12);
        document.cookie = name + "=" + value + ";path=/;expires=" + expire.toGMTString();
    }

    function closeUeNotify() {
        var el = document.getElementById('cookieNotice');
        var anim = {$ue_config.ue_anim};
        setcook();
        if (anim === 1) {
            el.style.transition = "opacity 0.5s";
            el.style.opacity = "0";
            setTimeout(function() { el.style.display = 'none'; }, 500);
        } else {
            el.style.transition = "all 0.5s ease-in-out";
            {if $ue_config.ue_pos == 1} el.style.top = "-250px"; {else} el.style.bottom = "-250px"; {/if}
            setTimeout(function() { el.style.display = 'none'; }, 500);
        }
    }
</script>