<?php
/**
 * PrestaShop module created by VEKIA, a guy from official PrestaShop community ;-)
 *
 * @author    VEKIA PL MILOSZ MYSZCZUK VATEU: PL9730945634
 * @copyright 2010-2026 VEKIA
 * @license   This program is not free software and you can't resell and redistribute it
 *
 * CONTACT WITH DEVELOPER http://mypresta.eu
 * support@mypresta.eu
 */
if (!defined('_PS_VERSION_')) {
    exit;
}

class twitterwidget extends Module
{
    public $mkey;
    public $mypresta_link;
    public $dir;

    public function __construct()
    {
        $this->name      = 'twitterwidget';
        $this->tab       = 'social_networks';
        $this->version   = '1.4.1';
        $this->author    = 'MyPresta.eu & Modded';
        $this->dir       = '/modules/twitterwidget/';
        $this->mypresta_link = 'https://mypresta.eu/modules/social-networks/twitter-widget-free.html';
        $this->bootstrap = true;
        parent::__construct();

        // Zmieniono tylko warstwę wizualną w tłumaczeniach
        $this->displayName = $this->l('X Widget Free');
        $this->description = $this->l('This module adds an X (formerly Twitter) widget to your shop.');
        $this->mkey        = "freelicense";
    }

    public static function psversion($part = 1)
    {
        $version = _PS_VERSION_;
        $exp     = explode(".", $version);

        // Obsługa PrestaShop 8 i 9 (np. 8.0.0, 9.0.0)
        if ((int)$exp[0] >= 8) {
            if ($part == 1) {
                return (int)$exp[0];
            }
            if ($part == 2) {
                return isset($exp[1]) ? $exp[1] : 0;
            }
            if ($part == 3) {
                return isset($exp[2]) ? $exp[2] : 0;
            }
        }

        // Obsługa PrestaShop 1.6 i 1.7 (np. 1.6.1.24, 1.7.8.8)
        if ($part == 1) {
            return $exp[1];
        }
        if ($part == 2) {
            return $exp[2];
        }
        if ($part == 3) {
            return $exp[3];
        }
    }

    public function checkforupdates($display_msg = 0, $form = 0)
    {
        if (@file_exists('../modules/' . $this->name . '/key.php')) {
            @require_once('../modules/' . $this->name . '/key.php');
        } else {
            if (@file_exists(dirname(__FILE__) . $this->name . '/key.php')) {
                @require_once(dirname(__FILE__) . $this->name . '/key.php');
            } else {
                if (@file_exists('modules/' . $this->name . '/key.php')) {
                    @require_once('modules/' . $this->name . '/key.php');
                }
            }
        }
        if ($form == 1) {
            $ps_ver = $this->psversion();
            return '
            <div class="panel" id="fieldset_myprestaupdates" style="margin-top:20px;">
            ' . ($ps_ver == 6 || $ps_ver == 7 || $ps_ver == 8 || $ps_ver == 9 ? '<div class="panel-heading"><i class="icon-wrench"></i> ' . $this->l('MyPresta updates') . '</div>' : '') . '
			<div class="form-wrapper" style="padding:20px!important;">
            <div id="module_block_settings">
                    <fieldset id="fieldset_module_block_settings">
                         ' . ($ps_ver == 5 ? '<legend style="">' . $this->l('MyPresta updates') . '</legend>' : '') . '
                        <form action="' . $_SERVER['REQUEST_URI'] . '" method="post">
                            <label>' . $this->l('Check updates') . '</label>
                            <div class="margin-form">' . (Tools::isSubmit('submit_settings_updates_now') ? ($this->inconsistency(0) ? '' : '') . $this->checkforupdates(1) : '') . '
                                <button style="margin: 0px; top: -3px; position: relative;" type="submit" name="submit_settings_updates_now" class="button btn btn-default" />
                                <i class="process-icon-update"></i>
                                ' . $this->l('Check now') . '
                                </button>
                            </div>
                            <label>' . $this->l('Updates notifications') . '</label>
                            <div class="margin-form">
                                <select name="mypresta_updates">
                                    <option value="-">' . $this->l('-- select --') . '</option>
                                    <option value="1" ' . ((int)(Configuration::get('mypresta_updates') == 1) ? 'selected="selected"' : '') . '>' . $this->l('Enable') . '</option>
                                    <option value="0" ' . ((int)(Configuration::get('mypresta_updates') == 0) ? 'selected="selected"' : '') . '>' . $this->l('Disable') . '</option>
                                </select>
                                <p class="clear">' . $this->l('Turn this option on if you want to check MyPresta.eu for module updates automatically. This option will display notification about new versions of this addon.') . '</p>
                            </div>
                            <label>' . $this->l('Module page') . '</label>
                            <div class="margin-form">
                                <a style="font-size:14px;" href="' . $this->mypresta_link . '" target="_blank">' . $this->displayName . '</a>
                                <p class="clear">' . $this->l('This is direct link to official addon page, where you can read about changes in the module (changelog)') . '</p>
                            </div>
                            <div class="panel-footer">
                                <button type="submit" name="submit_settings_updates"class="button btn btn-default pull-right" />
                                <i class="process-icon-save"></i>
                                ' . $this->l('Save') . '
                                </button>
                            </div>
                        </form>
                    </fieldset>
                    <style>
                    #fieldset_myprestaupdates {
                        display:block;clear:both;
                        float:inherit!important;
                    }
                    </style>
                </div>
            </div>
            </div>';
        } else {
            if (defined('_PS_ADMIN_DIR_')) {
                if (Tools::isSubmit('submit_settings_updates')) {
                    Configuration::updateValue('mypresta_updates', Tools::getValue('mypresta_updates'));
                }
                if (Configuration::get('mypresta_updates') != 0 || (bool)Configuration::get('mypresta_updates') == false) {
                    if (Configuration::get('update_' . $this->name) < (date("U") - 259200)) {
                        $actual_version = twitterwidgetUpdate::verify($this->name, (isset($this->mkey) ? $this->mkey : 'nokey'), $this->version);
                    }
                    if (twitterwidgetUpdate::version($this->version) < twitterwidgetUpdate::version(Configuration::get('updatev_' . $this->name))) {
                        $this->warning = $this->l('New version available, check http://MyPresta.eu for more informations');
                    }
                }
                if ($display_msg == 1) {
                    if (twitterwidgetUpdate::version($this->version) < twitterwidgetUpdate::version(twitterwidgetUpdate::verify($this->name, (isset($this->mkey) ? $this->mkey : 'nokey'), $this->version))) {
                        return "<span style='color:red; font-weight:bold; font-size:16px; margin-right:10px;'>" . $this->l('New version available!') . "</span>";
                    } else {
                        return "<span style='color:green; font-weight:bold; font-size:16px; margin-right:10px;'>" . $this->l('Module is up to date!') . "</span>";
                    }
                }
            }
        }
    }


    public function install()
    {
        // Rejestrujemy nowe hooki dla zgodności z nowymi wersjami PrestaShop
        if (parent::install() == false
            OR ! Configuration::updateValue('update_' . $this->name, '0')
            OR $this->registerHook('displayRightColumn') == false
            OR $this->registerHook('displayHeader') == false
            OR $this->registerHook('displayLeftColumn') == false
            OR $this->registerHook('displayHome') == false
            OR $this->registerHook('displayFooter') == false
            OR Configuration::updateValue('twitterwidget_position', '2') == false
            OR Configuration::updateValue('twitterwidget_name', 'X') == false
            OR Configuration::updateValue('twitterwidget_width', '220') == false
            OR Configuration::updateValue('twitterwidget_height', '420') == false) {
            return false;
        }

        return true;
    }

    public function getContent()
    {
        $output = "";
        if (Tools::isSubmit('submit_settings')) {
            Configuration::updateValue('twitterwidget_position', Tools::getValue('new_twitterwidget_position'), true);
            Configuration::updateValue('twitterwidget_name', Tools::getValue('new_twitterwidget_name'), true);
            Configuration::updateValue('twitterwidget_width', Tools::getValue('new_twitterwidget_width'), true);
            Configuration::updateValue('twitterwidget_height', Tools::getValue('new_twitterwidget_height'), true);
            Configuration::updateValue('twitterwidget_color', Tools::getValue('new_twitterwidget_color'), true);
            Configuration::updateValue('twitterwidget_heading', Tools::getValue('new_twitterwidget_heading'), true);

            $this->context->controller->confirmations[] = $this->l('Settings properly saved');
        }

        return $this->displayForm() . $this->checkforupdates(0, 1);
    }

    public function getconf()
    {
        $var = new stdClass();
        $var->twitterwidget_position = Configuration::get('twitterwidget_position');
        $var->twitterwidget_name     = Configuration::get('twitterwidget_name');
        $var->twitterwidget_width    = Configuration::get('twitterwidget_width');
        $var->twitterwidget_height   = Configuration::get('twitterwidget_height');
        $var->twitterwidget_color    = Configuration::get('twitterwidget_color');
        $var->twitterwidget_heading  = Configuration::get('twitterwidget_heading');

        return $var;
    }

    public function displayForm()
    {
        $var           = $this->getconf();
        $twt_position1 = "";
        $twt_position2 = "";
        $twt_position3 = "";
        $twt_position4 = "";

        if ($var->twitterwidget_position == 1) $twt_position1 = "checked=\"yes\"";
        if ($var->twitterwidget_position == 2) $twt_position2 = "checked=\"yes\"";
        if ($var->twitterwidget_position == 3) $twt_position3 = "checked=\"yes\"";
        if ($var->twitterwidget_position == 4) $twt_position4 = "checked=\"yes\"";

        return '
        <style>
        .margin-form input, .margin-form select {max-width:200px;}
        </style>
		<form action="' . $_SERVER['REQUEST_URI'] . '" method="post">
            <div style="display:block; margin:auto; overflow:hidden; ">
                    <div style="clear:both; display:block; " class="panel">
                        <h3>' . $this->l('X Widget configuration') . '</h3>
                        <div class="nobootstrap" style="padding:0px!important">
			                <div style="clear:both;display:block;">
							    <label>' . $this->l('Left column') . ':</label>
								<div class="margin-form" valign="middle">
			                        <div style="margin-top:7px;">
									<input type="radio" name="new_twitterwidget_position" value="1" ' . $twt_position1 . '> ' . $this->l('yes') . '	
			                        </div>
								</div>
			                </div>
			                <div style="clear:both;display:block;">
							    <label>' . $this->l('Right column') . ':</label>
								<div class="margin-form" valign="middle">
			                        <div style="margin-top:7px;">
									<input type="radio" name="new_twitterwidget_position" value="2" ' . $twt_position2 . '> ' . $this->l('yes') . '									
			                        </div>
								</div>
			                </div>
							<div style="clear:both;display:block;">
							    <label>' . $this->l('Home') . ':</label>
								<div class="margin-form" valign="middle">
			                        <div style="margin-top:7px;">
									<input type="radio" name="new_twitterwidget_position" value="3" ' . $twt_position3 . '> ' . $this->l('yes') . '
									
			                        </div>
								</div>
			                </div>
                            <div style="clear:both;display:block;">
							    <label>' . $this->l('Footer') . ':</label>
								<div class="margin-form" valign="middle">
			                        <div style="margin-top:7px;">
									<input type="radio" name="new_twitterwidget_position" value="4" ' . $twt_position4 . '> ' . $this->l('yes') . '
									
			                        </div>
								</div>
			                </div>
			                
			                <label>' . $this->l('Box width') . '</label>
            					<div class="margin-form">
            						<input type="text" style="width:200px;" value="' . $var->twitterwidget_width . '" id="new_twitterwidget_width" name="new_twitterwidget_width" onchange="">
                                </div>
                                
                            <label>' . $this->l('Box height') . '</label>
            					<div class="margin-form">
            						<input type="text" style="width:200px;" value="' . $var->twitterwidget_height . '" id="new_twitterwidget_height" name="new_twitterwidget_height" onchange="">
                                </div>
                                
                            <label>' . $this->l('Box colors') . '</label>
            					<div class="margin-form">
            						<select id="new_twitterwidget_color" name="new_twitterwidget_color" onchange="">
                                        <option ' . ($var->twitterwidget_color == 'light' ? 'selected="yes"' : '') . ' value="light">' . $this->l('Light colors') . '</option>
                                        <option ' . ($var->twitterwidget_color == 'dark' ? 'selected="yes"' : '') . ' value="dark">' . $this->l('Dark colors') . '</option>
            						</select>
                                </div>
                                
                            <label>' . $this->l('Heading') . '</label>
            					<div class="margin-form">
            						<select id="new_twitterwidget_heading" name="new_twitterwidget_heading" onchange="">
                                        <option ' . ($var->twitterwidget_heading == '1' ? 'selected="yes"' : '') . ' value="1">' . $this->l('Yes') . '</option>
                                        <option ' . ($var->twitterwidget_heading != '1' ? 'selected="yes"' : '') . ' value="0">' . $this->l('No') . '</option>
            						</select>
            						<p class="description">' . $this->l('This option when enabled will create a box with heading "X"') . '</p>
                                </div>                                
				                            
            				<label>' . $this->l('X name') . '</label>
            					<div class="margin-form">
            						<input type="text" style="width:400px;" value="' . $var->twitterwidget_name . '" id="new_twitterwidget_name" name="new_twitterwidget_name" onchange="">
                                    <p class="clear">' . $this->l('Your account on X name (e.g. myprestaeu)') . '</p>
                                </div>
                                
                                <input name="submit_settings" type="hidden">
                        </div>    
                        <div class="panel-footer">
                        <button class="button btn btn-default pull-right"><i class="process-icon-save"></i>'.$this->l('Save').'</button>
                        </div>                
                    </div>
            </div>
		</form>
        ';
    }

    public function hookDisplayRightColumn($params)
    {
        if (Configuration::get('twitterwidget_position') == 2) {
            $this->context->smarty->assign('twt', $this->getconf());
            return $this->display(__FILE__, 'rightcolumn.tpl');
        }
    }
    public function hookRightColumn($params) { return $this->hookDisplayRightColumn($params); }

    public function hookDisplayLeftColumn($params)
    {
        if (Configuration::get('twitterwidget_position') == 1) {
            $this->context->smarty->assign('twt', $this->getconf());
            return $this->display(__FILE__, 'rightcolumn.tpl');
        }
    }
    public function hookLeftColumn($params) { return $this->hookDisplayLeftColumn($params); }

    public function inconsistency($ret = 0)
    {
        return;
    }

    public function hookDisplayHome($params)
    {
        if (Configuration::get('twitterwidget_position') == 3) {
            $this->context->smarty->assign('twt', $this->getconf());
            return $this->display(__FILE__, 'rightcolumn.tpl');
        }
    }
    public function hookHome($params) { return $this->hookDisplayHome($params); }

    public function hookDisplayHeader($params)
    {
        $this->context->controller->addCSS($this->_path . 'twitterwidget.css');
    }
    public function hookHeader($params) { return $this->hookDisplayHeader($params); }

    public function hookDisplayFooter($params)
    {
        if (Configuration::get('twitterwidget_position') == 4) {
            $this->context->smarty->assign('twt', $this->getconf());
            return $this->display(__FILE__, 'rightcolumn.tpl');
        }
    }
    public function hookFooter($params) { return $this->hookDisplayFooter($params); }
}

class twitterwidgetUpdate extends twitterwidget
{
    public static function version($version)
    {
        $version = (int)str_replace(".", "", $version);
        if (strlen($version) == 3) {
            $version = (int)$version . "0";
        }
        if (strlen($version) == 2) {
            $version = (int)$version . "00";
        }
        if (strlen($version) == 1) {
            $version = (int)$version . "000";
        }
        if (strlen($version) == 0) {
            $version = (int)$version . "0000";
        }

        return (int)$version;
    }

    public static function encrypt($string)
    {
        return base64_encode($string);
    }

    public static function verify($module, $key, $version)
    {
        if (ini_get("allow_url_fopen")) {
            if (function_exists("file_get_contents")) {
                $actual_version = @file_get_contents('http://dev.mypresta.eu/update/get.php?module=' . $module . "&version=" . self::encrypt($version) . "&lic=$key&u=" . self::encrypt(_PS_BASE_URL_ . __PS_BASE_URI__));
            }
        }
        Configuration::updateValue("update_" . $module, date("U"));
        Configuration::updateValue("updatev_" . $module, isset($actual_version) ? $actual_version : '0');

        return isset($actual_version) ? $actual_version : '0';
    }
}
?>