<?php

/**
 * PrestaShop module created by VEKIA, a guy from official PrestaShop community ;-)
 *
 * @author    VEKIA PL MILOSZ MYSZCZUK VATEU: PL9730945634
 * @copyright 2010-2026 VEKIA
 * @license   This program is not free software and you can't resell and redistribute it
 *
 * CONTACT WITH DEVELOPER http://mypresta.eu
 * support@mypresta.eu
 */

if (!defined('_PS_VERSION_')) {
    exit;
}

class socialnetworklinks extends Module
{
    public $mypresta_link;
    public $mkey;
    protected $social_platforms = array(
        'facebook', 'twitter', 'youtube', 'google', 'linkedin', 'rss', 'instagram', 'flickr',
        'vkontakte', 'odnru', 'nk', 'pinterest', 'myspace', 'lastfm', 'yelp', 'picsart',
        'tumblr', 'digg', 'wordpress', 'deviantart', 'weibo', 'qzone', 'formspring',
        'blogger', 'ljournal', 'ask', 'orkut', 'googlep', 'apple', 'adobe', 'vimeo',
        'spotify', 'discord', 'tiktok'
    );
    public function inconsistency($ret)
    {
        return true;
    }

    public function __construct()
    {
        $this->name = 'socialnetworklinks';
        $this->tab = 'social_networks';
        $this->author = 'MyPresta.eu';
        $this->version = '1.6.0';
        $this->mypresta_link = 'https://mypresta.eu/modules/social-networks/social-network-links.html';
        $this->bootstrap = true;
        parent::__construct();

        $this->displayName = $this->l('Social Network Links');
        $this->description = $this->l('Module creates animated social network links with advanced styling and live preview');
        $this->ps_versions_compliancy = array('min' => '1.6', 'max' => _PS_VERSION_);

        $this->checkforupdates();
    }

    public function install()
    {
        $languages = Language::getLanguages(false);
        $header = array();
        foreach ($languages as $lang) {
            $header[$lang['id_lang']] = 'Our social networks';
        }

        if (!parent::install() ||
            !$this->registerHook('displayHeader') ||
            !$this->registerHook('displayTop') ||
            !$this->registerHook('displayFooter') ||
            !$this->registerHook('displayLeftColumn') ||
            !$this->registerHook('displayRightColumn') ||
            !Configuration::updateValue('snl_header', $header, true) ||
            !Configuration::updateValue('snl_where', '3') ||
            !Configuration::updateValue('snl_bg_color', '#ffffff') ||
            !Configuration::updateValue('snl_text_color', '#333333') ||
            !Configuration::updateValue('snl_border_style', 'solid') ||
            !Configuration::updateValue('snl_border_color', '#cccccc') ||
            !Configuration::updateValue('snl_border_size', '1') ||
            !Configuration::updateValue('snl_border_radius', '5')
        ) {
            return false;
        }

        Configuration::updateValue('snl_facebook', 1);
        Configuration::updateValue('snl_facebook_url', 'http://facebook.com/mypresta');

        if ($this->psversion() >= 7) {
            $this->registerHook('displayNav1');
            $this->registerHook('displayNav2');
        }

        return true;
    }

    public function psversion($part = 1)
    {
        $version = _PS_VERSION_;
        $exp = explode('.', $version);
        if ($exp[0] == '1') {
            if ($part == 1) return (int)$exp[1];
        } else {
            if ($part == 1) return (int)$exp[0];
        }
        return 0;
    }

    public function getContent()
    {
        $output = '';
        if (Tools::isSubmit('submit' . $this->name)) {
            $this->postProcess();
            $output .= $this->displayConfirmation($this->l('Settings updated successfully.'));
        }

        return $output . $this->renderAdds() . $this->renderLivePreview() . $this->renderForm() . $this->renderGradientBuilderJS() . $this->checkforupdates(0, 1);
    }

    protected function postProcess()
    {
        Configuration::updateValue('snl_where', Tools::getValue('snl_where'));
        Configuration::updateValue('snl_bg_color', Tools::getValue('snl_bg_color'));
        Configuration::updateValue('snl_bg_gradient', Tools::getValue('snl_bg_gradient'), true);
        Configuration::updateValue('snl_text_color', Tools::getValue('snl_text_color'));
        Configuration::updateValue('snl_border_style', Tools::getValue('snl_border_style'));
        Configuration::updateValue('snl_border_color', Tools::getValue('snl_border_color'));
        Configuration::updateValue('snl_border_size', Tools::getValue('snl_border_size'));
        Configuration::updateValue('snl_border_radius', Tools::getValue('snl_border_radius'));

        $languages = Language::getLanguages(false);
        $header = array();
        foreach ($languages as $lang) {
            $header[$lang['id_lang']] = Tools::getValue('snl_header_' . $lang['id_lang']);
        }
        Configuration::updateValue('snl_header', $header, true);

        foreach ($this->social_platforms as $platform) {
            Configuration::updateValue('snl_' . $platform, (int)Tools::getValue('snl_' . $platform));
            Configuration::updateValue('snl_' . $platform . '_url', Tools::getValue('snl_' . $platform . '_url'));
        }
    }

    public function renderForm()
    {
        $fields_form = array(
            'form' => array(
                'legend' => array(
                    'title' => $this->l('Module Settings'),
                    'icon' => 'icon-cogs'
                ),
                'input' => array(
                    array(
                        'type' => 'text',
                        'label' => $this->l('Header'),
                        'name' => 'snl_header',
                        'lang' => true,
                    ),
                    array(
                        'type' => 'select',
                        'label' => $this->l('Where to display?'),
                        'name' => 'snl_where',
                        'options' => array(
                            'query' => array(
                                array('id' => '0', 'name' => 'displayTop'),
                                array('id' => '1', 'name' => 'displayLeftColumn'),
                                array('id' => '2', 'name' => 'displayRightColumn'),
                                array('id' => '3', 'name' => 'displayFooter'),
                                array('id' => '5', 'name' => 'displayNav1'),
                                array('id' => '6', 'name' => 'displayNav2'),
                            ),
                            'id' => 'id',
                            'name' => 'name'
                        )
                    ),
                    array(
                        'type' => 'color',
                        'label' => $this->l('Text & Header color'),
                        'name' => 'snl_text_color',
                    ),
                    array(
                        'type' => 'color',
                        'label' => $this->l('Background color'),
                        'name' => 'snl_bg_color',
                    ),
                    array(
                        'type' => 'text',
                        'label' => $this->l('Background gradient'),
                        'name' => 'snl_bg_gradient',
                        'id' => 'snl_bg_gradient',
                        'desc' => $this->l('Use the configurator below to generate CSS.'),
                    ),
                    array(
                        'type' => 'select',
                        'label' => $this->l('Border style'),
                        'name' => 'snl_border_style',
                        'options' => array(
                            'query' => array(
                                array('id' => 'none', 'name' => $this->l('None')),
                                array('id' => 'solid', 'name' => $this->l('Solid')),
                                array('id' => 'dashed', 'name' => $this->l('Dashed')),
                                array('id' => 'dotted', 'name' => $this->l('Dotted')),
                            ),
                            'id' => 'id',
                            'name' => 'name'
                        )
                    ),
                    array(
                        'type' => 'color',
                        'label' => $this->l('Border color'),
                        'name' => 'snl_border_color',
                    ),
                    array(
                        'type' => 'text',
                        'label' => $this->l('Border size'),
                        'name' => 'snl_border_size',
                        'suffix' => 'px',
                        'class' => 'fixed-width-xs'
                    ),
                    array(
                        'type' => 'text',
                        'label' => $this->l('Border radius'),
                        'name' => 'snl_border_radius',
                        'suffix' => 'px',
                        'class' => 'fixed-width-xs'
                    ),
                ),
                'submit' => array(
                    'title' => $this->l('Save settings'),
                )
            ),
        );

        foreach ($this->social_platforms as $platform) {
            $fields_form['form']['input'][] = array(
                'type' => 'switch',
                'label' => ucfirst($platform),
                'name' => 'snl_' . $platform,
                'is_bool' => true,
                'values' => array(
                    array('id' => 'active_on', 'value' => 1, 'label' => $this->l('Yes')),
                    array('id' => 'active_off', 'value' => 0, 'label' => $this->l('No'))
                ),
            );
            $fields_form['form']['input'][] = array(
                'type' => 'text',
                'label' => $this->l('URL for') . ' ' . ucfirst($platform),
                'name' => 'snl_' . $platform . '_url',
                'form_group_class' => 'snl-group-' . $platform,
            );
        }

        $helper = new HelperForm();
        $helper->module = $this;
        $helper->name_controller = $this->name;
        $helper->token = Tools::getAdminTokenLite('AdminModules');
        $helper->currentIndex = AdminController::$currentIndex . '&configure=' . $this->name;
        $helper->default_form_language = $this->context->language->id;
        $helper->allow_employee_form_lang = Configuration::get('PS_BO_ALLOW_EMPLOYEE_FORM_LANG', 0);
        $helper->submit_action = 'submit' . $this->name;

        $helper->tpl_vars = array(
            'fields_value' => $this->getConfigFieldsValues(),
            'languages' => $this->context->controller->getLanguages(),
            'id_language' => $this->context->language->id
        );

        return $helper->generateForm(array($fields_form)) . $this->renderSwitchLogicJS();
    }

    public function getConfigFieldsValues()
    {
        $values = array(
            'snl_where' => Configuration::get('snl_where'),
            'snl_bg_color' => Configuration::get('snl_bg_color'),
            'snl_bg_gradient' => Configuration::get('snl_bg_gradient'),
            'snl_text_color' => Configuration::get('snl_text_color'),
            'snl_border_style' => Configuration::get('snl_border_style'),
            'snl_border_color' => Configuration::get('snl_border_color'),
            'snl_border_size' => Configuration::get('snl_border_size'),
            'snl_border_radius' => Configuration::get('snl_border_radius'),
        );

        foreach (Language::getLanguages(false) as $lang) {
            $values['snl_header'][$lang['id_lang']] = Configuration::get('snl_header', $lang['id_lang']);
        }

        foreach ($this->social_platforms as $platform) {
            $values['snl_' . $platform] = Configuration::get('snl_' . $platform);
            $values['snl_' . $platform . '_url'] = Configuration::get('snl_' . $platform . '_url');
        }

        return $values;
    }

    public function renderSwitchLogicJS()
    {
        return '
        <script type="text/javascript">
            $(document).ready(function() {
                function syncSnlUrlFields() {
                    $("input[name^=\'snl_\']").each(function() {
                        if ($(this).attr("type") === "radio" && $(this).is(":checked")) {
                            var name = $(this).attr("name");
                            var val = $(this).val();
                            var platform = name.replace("snl_", "");
                            var $group = $(".snl-group-" + platform);
                            if (val == "1") $group.show(); else $group.hide();
                        }
                    });
                }
                $(document).on("change", "input[name^=\'snl_\']", syncSnlUrlFields);
                syncSnlUrlFields();
            });
        </script>';
    }

    public function renderLivePreview()
    {
        return '
        <div class="panel" style="margin-bottom: 20px;">
            <div class="panel-heading"><i class="icon-eye"></i> ' . $this->l('Live Preview') . '</div>
            <div style="padding: 40px; background: url(\'../img/bg_pattern.png\') #f4f6f9; border: 1px dashed #ccc; display: flex; justify-content: center;">
                <div id="snl-preview-box" style="padding: 25px; text-align: center; min-width: 300px; box-shadow: 0 5px 15px rgba(0,0,0,0.1); transition: all 0.3s ease;">
                    <h4 id="snl-preview-header" style="margin-top:0; font-weight:bold; font-size: 1.3em;">Social Network Links</h4>
                    <div style="display:flex; justify-content:center; gap:10px; flex-wrap:wrap; margin-top:20px;">
                        <span style="width:24px; height:24px; background:#3b5998; border-radius:50%; display:inline-block;"></span>
                        <span style="width:24px; height:24px; background:#1da1f2; border-radius:50%; display:inline-block;"></span>
                        <span style="width:24px; height:24px; background:#e1306c; border-radius:50%; display:inline-block;"></span>
                        <span style="width:24px; height:24px; background:#ff0000; border-radius:50%; display:inline-block;"></span>
                    </div>
                </div>
            </div>
        </div>
        <script>
            $(document).ready(function() {
                function updateSnlPreview() {
                    var grad = $("input[name=\'snl_bg_gradient\']").val();
                    var bg = (grad && grad.trim() !== "") ? grad : $("input[name=\'snl_bg_color\']").val();
                    var txt = $("input[name=\'snl_text_color\']").val() || "#333333";
                    
                    $("#snl-preview-box").css({
                        "background": bg,
                        "color": txt,
                        "border-style": $("select[name=\'snl_border_style\']").val(),
                        "border-color": $("input[name=\'snl_border_color\']").val(),
                        "border-width": ($("input[name=\'snl_border_size\']").val() || 0) + "px",
                        "border-radius": ($("input[name=\'snl_border_radius\']").val() || 0) + "px"
                    });
                    $("#snl-preview-header").text($("input[name^=\'snl_header_\']:visible").val() || "Social Links").css("color", txt);
                }
                $(document).on("input change", "input[name^=\'snl_\'], select[name^=\'snl_\']", updateSnlPreview);
                setInterval(updateSnlPreview, 600);
            });
        </script>';
    }

    public function renderGradientBuilderJS()
    {
        return '
        <script type="text/javascript">
        $(document).ready(function(){
            var $target = $(\'input[name="snl_bg_gradient"]\');
            if($target.length === 0) return;

            var html = "<div id=\'snl_gb\' style=\'margin-top:10px; padding:15px; border:1px solid #d3d8db; background:#f5f8f9; border-radius:3px;\'>" +
                "<h4 style=\'margin-top:0;\'>' . $this->l('Gradient Configurator') . '</h4>" +
                "<div style=\'display:flex; gap:10px; margin-bottom:10px;\'>" +
                    "<select id=\'gb_type\' class=\'form-control\' style=\'width:auto;\'><option value=\'linear-gradient\'>Linear</option><option value=\'radial-gradient\'>Radial</option></select>" +
                    "<select id=\'gb_dir\' class=\'form-control\' style=\'width:auto;\'><option value=\'to right\'>To Right</option><option value=\'to bottom\'>To Bottom</option><option value=\'45deg\'>45 Deg</option><option value=\'circle\'>Circle</option></select>" +
                "</div>" +
                "<div id=\'gb_colors\' style=\'display:flex; gap:8px; margin-bottom:10px; flex-wrap:wrap;\'></div>" +
                "<button type=\'button\' id=\'gb_add\' class=\'btn btn-default btn-sm\'><i class=\'icon-plus\'></i> Add Color</button>" +
                "<div id=\'gb_prev\' style=\'height:50px; border:1px solid #ccc; margin-top:10px; border-radius:4px;\'></div>" +
            "</div>";

            $target.after(html);
            var colors = ["#ece9e6", "#ffffff"];

            function draw() {
                var c_html = "";
                $.each(colors, function(i, c) {
                    c_html += "<div style=\'display:flex; gap:2px;\'><input type=\'color\' class=\'gb_c\' data-i=\'"+i+"\' value=\'"+c+"\'>" + (colors.length > 2 ? "<button type=\'button\' class=\'gb_r\' data-i=\'"+i+"\'>x</button>" : "") + "</div>";
                });
                $("#gb_colors").html(c_html);
                var css = $("#gb_type").val() + "(" + $("#gb_dir").val() + ", " + colors.join(", ") + ")";
                $("#gb_prev").css("background", css);
                $target.val(css).trigger("change");
            }

            $(document).on("change", ".gb_c", function(){ colors[$(this).data("i")] = $(this).val(); draw(); });
            $(document).on("click", ".gb_r", function(){ colors.splice($(this).data("i"), 1); draw(); });
            $("#gb_add").click(function(){ colors.push("#ffffff"); draw(); });
            $("#gb_type, #gb_dir").change(draw);
            draw();
        });
        </script>';
    }

    public function renderAdds()
    {
        return '<div style="margin-bottom:20px;"><iframe src="//dev.addons.ovh/modules.html?module='.$this->name.'" width="100%" height="130" style="border:none;"></iframe></div>';
    }

    public function hookDisplayHeader()
    {
        $this->context->controller->addCSS($this->_path . 'css/socialnetworklinks.css');
    }

    protected function getWidgetVariables()
    {
        $id_lang = $this->context->language->id;
        $vars = array(
            'header' => Configuration::get('snl_header', $id_lang),
            'bg_color' => Configuration::get('snl_bg_color'),
            'bg_gradient' => Configuration::get('snl_bg_gradient'),
            'text_color' => Configuration::get('snl_text_color'),
            'border_style' => Configuration::get('snl_border_style'),
            'border_color' => Configuration::get('snl_border_color'),
            'border_size' => (int)Configuration::get('snl_border_size'),
            'border_radius' => (int)Configuration::get('snl_border_radius'),
            'platforms' => array()
        );

        foreach ($this->social_platforms as $platform) {
            if ((int)Configuration::get('snl_' . $platform) === 1) {
                $url = Configuration::get('snl_' . $platform . '_url');
                if (!empty($url)) {
                    $vars['platforms'][$platform] = $url;
                }
            }
        }
        return $vars;
    }

    public function hookDisplayTop($params) { if (Configuration::get('snl_where') == 0) return $this->renderWidget(); }
    public function hookDisplayLeftColumn($params) { if (Configuration::get('snl_where') == 1) return $this->renderWidget(); }
    public function hookDisplayRightColumn($params) { if (Configuration::get('snl_where') == 2) return $this->renderWidget(); }
    public function hookDisplayFooter($params) { if (Configuration::get('snl_where') == 3) return $this->renderWidget(); }
    public function hookDisplayNav1($params) { if (Configuration::get('snl_where') == 5) return $this->renderWidget(); }
    public function hookDisplayNav2($params) { if (Configuration::get('snl_where') == 6) return $this->renderWidget(); }

    public function renderWidget()
    {
        $this->context->smarty->assign('snl', $this->getWidgetVariables());
        return $this->display(__FILE__, 'views/front/column.tpl');
    }

    public function checkforupdates($display_msg = 0, $form = 0)
    {
        // ---------- //
        // ---------- //
        // VERSION 16 //
        // ---------- //
        // ---------- //
        $this->mkey = "nlc";
        if (@file_exists('../modules/' . $this->name . '/key.php')) {
            @require_once('../modules/' . $this->name . '/key.php');
        } else {
            if (@file_exists(dirname(__FILE__) . $this->name . '/key.php')) {
                @require_once(dirname(__FILE__) . $this->name . '/key.php');
            } else {
                if (@file_exists('modules/' . $this->name . '/key.php')) {
                    @require_once('modules/' . $this->name . '/key.php');
                }
            }
        }
        if ($form == 1) {
            return '
            <div class="panel" id="fieldset_myprestaupdates" style="margin-top:20px;">
            ' . ($this->psversion() == 6 || $this->psversion() == 7 ? '<div class="panel-heading"><i class="icon-wrench"></i> ' . $this->l('MyPresta updates') . '</div>' : '') . '
			<div class="form-wrapper" style="padding:20px!important;">
            <div id="module_block_settings">
                    <fieldset id="fieldset_module_block_settings">
                         ' . ($this->psversion() == 5 ? '<legend style="">' . $this->l('MyPresta updates') . '</legend>' : '') . '
                        <form action="' . $_SERVER['REQUEST_URI'] . '" method="post">
                            <label>' . $this->l('Check updates') . '</label>
                            <div class="margin-form">' . (Tools::isSubmit('submit_settings_updates_now') ? ($this->inconsistency(0) ? '' : '') . $this->checkforupdates(1) : '') . '
                                <button style="margin: 0px; top: -3px; position: relative;" type="submit" name="submit_settings_updates_now" class="button btn btn-default" />
                                <i class="process-icon-update"></i>
                                ' . $this->l('Check now') . '
                                </button>
                            </div>
                            <label>' . $this->l('Updates notifications') . '</label>
                            <div class="margin-form">
                                <select name="mypresta_updates">
                                    <option value="-">' . $this->l('-- select --') . '</option>
                                    <option value="1" ' . ((int)(Configuration::get('mypresta_updates') == 1) ? 'selected="selected"' : '') . '>' . $this->l('Enable') . '</option>
                                    <option value="0" ' . ((int)(Configuration::get('mypresta_updates') == 0) ? 'selected="selected"' : '') . '>' . $this->l('Disable') . '</option>
                                </select>
                                <p class="clear">' . $this->l('Turn this option on if you want to check MyPresta.eu for module updates automatically. This option will display notification about new versions of this addon.') . '</p>
                            </div>
                            <label>' . $this->l('Module page') . '</label>
                            <div class="margin-form">
                                <a style="font-size:14px;" href="' . $this->mypresta_link . '" target="_blank">' . $this->displayName . '</a>
                                <p class="clear">' . $this->l('This is direct link to official addon page, where you can read about changes in the module (changelog)') . '</p>
                            </div>
                            <div class="panel-footer">
                                <button type="submit" name="submit_settings_updates"class="button btn btn-default pull-right" />
                                <i class="process-icon-save"></i>
                                ' . $this->l('Save') . '
                                </button>
                            </div>
                        </form>
                    </fieldset>
                    <style>
                    #fieldset_myprestaupdates {
                        display:block;clear:both;
                        float:inherit!important;
                    }
                    </style>
                </div>
            </div>
            </div>';
        } else {
            if (defined('_PS_ADMIN_DIR_')) {
                if (Tools::isSubmit('submit_settings_updates')) {
                    Configuration::updateValue('mypresta_updates', Tools::getValue('mypresta_updates'));
                }
                if (Configuration::get('mypresta_updates') != 0 || (bool)Configuration::get('mypresta_updates') != false) {
                    if (Configuration::get('update_' . $this->name) < (date("U") - 259200)) {
                        $actual_version = socialnetworklinksUpdate::verify($this->name, (isset($this->mkey) ? $this->mkey : 'nokey'), $this->version);
                    }
                    if (socialnetworklinksUpdate::version($this->version) < socialnetworklinksUpdate::version(Configuration::get('updatev_' . $this->name)) && Tools::getValue('ajax', 'false') == 'false') {
                        $this->context->controller->warnings[] = '<strong>' . $this->displayName . '</strong>: ' . $this->l('New version available, check http://MyPresta.eu for more informations') . ' <a href="' . $this->mypresta_link . '">' . $this->l('More details in changelog') . '</a>';
                        $this->warning = $this->context->controller->warnings[0];
                    }
                } else {
                    if (Configuration::get('update_' . $this->name) < (date("U") - 259200)) {
                        $actual_version = socialnetworklinksUpdate::verify($this->name, (isset($this->mkey) ? $this->mkey : 'nokey'), $this->version);
                    }
                }
                if ($display_msg == 1) {
                    if (socialnetworklinksUpdate::version($this->version) < socialnetworklinksUpdate::version(socialnetworklinksUpdate::verify($this->name, (isset($this->mkey) ? $this->mkey : 'nokey'), $this->version))) {
                        return "<span style='color:red; font-weight:bold; font-size:16px; margin-right:10px;'>" . $this->l('New version available!') . "</span>";
                    } else {
                        return "<span style='color:green; font-weight:bold; font-size:16px; margin-right:10px;'>" . $this->l('Module is up to date!') . "</span>";
                    }
                }
            }
        }
    }
}


class socialnetworklinksUpdate extends socialnetworklinks
{
    public static function version($version)
    {
        $version = (int)str_replace(".", "", $version);
        if (strlen($version) == 3) {
            $version = (int)$version . "0";
        }
        if (strlen($version) == 2) {
            $version = (int)$version . "00";
        }
        if (strlen($version) == 1) {
            $version = (int)$version . "000";
        }
        if (strlen($version) == 0) {
            $version = (int)$version . "0000";
        }
        return (int)$version;
    }

    public static function encrypt($string)
    {
        return base64_encode($string);
    }

    public static function verify($module, $key, $version)
    {
        if (ini_get("allow_url_fopen")) {
            if (function_exists("file_get_contents")) {
                $actual_version = @file_get_contents('http://dev.mypresta.eu/update/get.php?module=' . $module . "&version=" . self::encrypt($version) . "&lic=$key&u=" . self::encrypt(_PS_BASE_URL_ . __PS_BASE_URI__));
            }
        }
        Configuration::updateValue("update_" . $module, date("U"));
        Configuration::updateValue("updatev_" . $module, $actual_version);
        return $actual_version;
    }
}