<?php

class likeboxfree extends Module
{
    public $msg;
    public $mkey;
    public $dir;
    
    function __construct()
    {
        $this->name = 'likeboxfree';
        $this->tab = 'social_networks';
        $this->version = '2.5.1';
        $this->author = 'MyPresta.eu';
        $this->dir = '/modules/likeboxfree/';
        parent::__construct();
        $this->displayName = $this->l('Fanpage Likebox Free');
        $this->description = $this->l('This module add special likebox block with your fanpage on Facebook. Now anybody can like your facebook fanpage!');
        $this->mkey = "freelicense";
        $this->checkforupdates(0,0);
    }

    public static function psversion($part = 1)
    {
        $version = _PS_VERSION_;
        $exp = explode('.', $version);
        if ($part == 0) {
            if ($exp[0] >= 8) {
                return 7;
            }
            return $exp[0];
        }
        if ($part == 1) {
            if ($exp[0] >= 8) {
                return 7;
            }
            return $exp[1];
        }
        if ($part == 2) {
            return $exp[2];
        }
        if ($part == 3) {
            return $exp[3];
        }
    }


    public function checkforupdates($display_msg = 0, $form = 0)
    {
        // ---------- //
        // ---------- //
        // VERSION 16 //
        // ---------- //
        // ---------- //
        $this->mkey = "nlc";
        if (@file_exists('../modules/' . $this->name . '/key.php')) {
            @require_once('../modules/' . $this->name . '/key.php');
        } else {
            if (@file_exists(dirname(__FILE__) . $this->name . '/key.php')) {
                @require_once(dirname(__FILE__) . $this->name . '/key.php');
            } else {
                if (@file_exists('modules/' . $this->name . '/key.php')) {
                    @require_once('modules/' . $this->name . '/key.php');
                }
            }
        }
        if ($form == 1) {
            return '
            <div class="panel" id="fieldset_myprestaupdates" style="margin-top:20px;">
            ' . ($this->psversion() == 6 || $this->psversion() == 7 ? '<div class="panel-heading"><i class="icon-wrench"></i> ' . $this->l('MyPresta updates') . '</div>' : '') . '
			<div class="form-wrapper" style="padding:0px!important;">
            <div id="module_block_settings">
                    <fieldset id="fieldset_module_block_settings">
                         ' . ($this->psversion() == 5 ? '<legend style="">' . $this->l('MyPresta updates') . '</legend>' : '') . '
                        <form action="' . $_SERVER['REQUEST_URI'] . '" method="post">
                            <label>' . $this->l('Check updates') . '</label>
                            <div class="margin-form">' . (Tools::isSubmit('submit_settings_updates_now') ? ($this->inconsistency(0) ? '' : '') . $this->checkforupdates(1) : '') . '
                                <button style="margin: 0px; top: -3px; position: relative;" type="submit" name="submit_settings_updates_now" class="button btn btn-default" />
                                <i class="process-icon-update"></i>
                                ' . $this->l('Check now') . '
                                </button>
                            </div>
                            <label>' . $this->l('Updates notifications') . '</label>
                            <div class="margin-form">
                                <select name="mypresta_updates">
                                    <option value="-">' . $this->l('-- select --') . '</option>
                                    <option value="1" ' . ((int)(Configuration::get('mypresta_updates') == 1) ? 'selected="selected"' : '') . '>' . $this->l('Enable') . '</option>
                                    <option value="0" ' . ((int)(Configuration::get('mypresta_updates') == 0) ? 'selected="selected"' : '') . '>' . $this->l('Disable') . '</option>
                                </select>
                                <p class="clear">' . $this->l('Turn this option on if you want to check MyPresta.eu for module updates automatically. This option will display notification about new versions of this addon.') . '</p>
                            </div>
                            <label>' . $this->l('Module page') . '</label>
                            <div class="margin-form">
                                <a style="font-size:14px;" href="' . $this->mypresta_link . '" target="_blank">' . $this->displayName . '</a>
                                <p class="clear">' . $this->l('This is direct link to official addon page, where you can read about changes in the module (changelog)') . '</p>
                            </div>
                            <div class="panel-footer">
                                <button type="submit" name="submit_settings_updates"class="button btn btn-default pull-right" />
                                <i class="process-icon-save"></i>
                                ' . $this->l('Save') . '
                                </button>
                            </div>
                        </form>
                    </fieldset>
                    <style>
                    #fieldset_myprestaupdates {
                        display:block;clear:both;
                        float:inherit!important;
                    }
                    </style>
                </div>
            </div>
            </div>';
        } else {
            if (defined('_PS_ADMIN_DIR_')) {
                if (Tools::isSubmit('submit_settings_updates')) {
                    Configuration::updateValue('mypresta_updates', Tools::getValue('mypresta_updates'));
                }
                if (Configuration::get('mypresta_updates') != 0 || (bool)Configuration::get('mypresta_updates') != false) {
                    if (Configuration::get('update_' . $this->name) < (date("U") - 259200)) {
                        $actual_version = likeboxfreeUpdate::verify($this->name, (isset($this->mkey) ? $this->mkey : 'nokey'), $this->version);
                    }
                    if (likeboxfreeUpdate::version($this->version) < likeboxfreeUpdate::version(Configuration::get('updatev_' . $this->name)) && Tools::getValue('ajax', 'false') == 'false') {
                        $this->context->controller->warnings[] = '<strong>' . $this->displayName . '</strong>: ' . $this->l('New version available, check http://MyPresta.eu for more informations') . ' <a href="' . $this->mypresta_link . '">' . $this->l('More details in changelog') . '</a>';
                        $this->warning = $this->context->controller->warnings[0];
                    }
                } else {
                    if (Configuration::get('update_' . $this->name) < (date("U") - 259200)) {
                        $actual_version = likeboxfreeUpdate::verify($this->name, (isset($this->mkey) ? $this->mkey : 'nokey'), $this->version);
                    }
                }
                if ($display_msg == 1) {
                    if (likeboxfreeUpdate::version($this->version) < likeboxfreeUpdate::version(likeboxfreeUpdate::verify($this->name, (isset($this->mkey) ? $this->mkey : 'nokey'), $this->version))) {
                        return "<span style='color:red; font-weight:bold; font-size:16px; margin-right:10px;'>" . $this->l('New version available!') . "</span>";
                    } else {
                        return "<span style='color:green; font-weight:bold; font-size:16px; margin-right:10px;'>" . $this->l('Module is up to date!') . "</span>";
                    }
                }
            }
        }
    }

    function install()
    {
        if (parent::install() == false OR
            !Configuration::updateValue('update_' . $this->name, '0') OR
            $this->registerHook('displayRightColumn') == false OR
            $this->registerHook('displayLeftColumn') == false OR
            $this->registerHook('displayHome') == false OR
            $this->registerHook('displayFooter') == false OR
            Configuration::updateValue('likeboxfree_position', '2') == false OR
            Configuration::updateValue('lbf_width', '191') == false OR
            Configuration::updateValue('lbf_height', '300') == false OR
            Configuration::updateValue('lbf_hide_cover', '0') == false OR
            Configuration::updateValue('lbf_show_facepile', '1') == false OR
            Configuration::updateValue('lbf_show_posts', '0') == false OR
            Configuration::updateValue('lbf_hide_cta', '0') == false OR
            Configuration::updateValue('lbf_small_header', '0') == false OR
            Configuration::updateValue('lbf_url', 'https://www.facebook.com/mypresta') == false)
        {
            return false;
        }
        return true;
    }

    public function getContent()
    {
        $output = '';

        // Zapisywanie formularza (tylko darmowe pola)
        if (Tools::isSubmit('submit_settings')) {
            Configuration::updateValue('likeboxfree_position', (int)Tools::getValue('likeboxfree_position'));
            Configuration::updateValue('lbf_width', Tools::getValue('lbf_width'));
            Configuration::updateValue('lbf_height', Tools::getValue('lbf_height'));
            Configuration::updateValue('lbf_hide_cover', (int)Tools::getValue('lbf_hide_cover'));
            Configuration::updateValue('lbf_show_facepile', (int)Tools::getValue('lbf_show_facepile'));
            Configuration::updateValue('lbf_show_posts', (int)Tools::getValue('lbf_show_posts'));
            Configuration::updateValue('lbf_hide_cta', (int)Tools::getValue('lbf_hide_cta'));
            Configuration::updateValue('lbf_small_header', (int)Tools::getValue('lbf_small_header'));
            Configuration::updateValue('lbf_url', Tools::getValue('lbf_url'));
            Configuration::updateValue('lbf_includeapp', (int)Tools::getValue('lbf_includeapp'));

            $output .= $this->displayConfirmation($this->l('Settings updated'));
        }

        $top_html = '<link href="' . $this->_path . 'css.css" rel="stylesheet" type="text/css" />
        <iframe src="//dev.addons.ovh/modules.html?module=' . $this->name . '" width="100%" height="150" border="0" style="border:none; display:block; margin:auto;"></iframe>';

        $bottom_html = '<div style="display:block; clear:both; margin-top:20px; text-align:center;">
        ' . $this->l('like us on Facebook') . '<br/><iframe src="//www.facebook.com/plugins/like.php?href=http%3A%2F%2Ffacebook.com%2Fmypresta&amp;send=false&amp;layout=button_count&amp;width=120&amp;show_faces=true&amp;font=verdana&amp;colorscheme=light&amp;action=like&amp;height=21&amp;appId=276212249177933" scrolling="no" frameborder="0" style="border:none; overflow:hidden; width:120px; height:21px; margin-top:10px;" allowtransparency="true"></iframe>
        <div style="float:right; text-align:right; display:inline-block; margin-top:10px; font-size:10px;">
        ' . $this->l('Proudly developed by') . ' <a href="http://mypresta.eu" style="font-weight:bold; color:#B73737">MyPresta<font style="color:black;">.eu</font></a>
        </div></div>';

        return $output . $top_html . $this->renderForm() . $bottom_html;
    }

    public function renderForm()
    {
        $switch_values = array(
            array('id' => 'active_on', 'value' => 1, 'label' => $this->l('Enabled')),
            array('id' => 'active_off', 'value' => 0, 'label' => $this->l('Disabled'))
        );

        $fields_form = array(
            array(
                'form' => array(
                    'legend' => array(
                        'title' => $this->l('Likebox configuration'),
                        'icon' => 'icon-cogs'
                    ),
                    'input' => array(
                        array(
                            'type' => 'radio',
                            'label' => $this->l('Position'),
                            'name' => 'likeboxfree_position',
                            'values' => array(
                                array('id' => 'pos_left', 'value' => 1, 'label' => $this->l('Left column')),
                                array('id' => 'pos_right', 'value' => 2, 'label' => $this->l('Right column')),
                                array('id' => 'pos_home', 'value' => 3, 'label' => $this->l('Homepage')),
                                array('id' => 'pos_footer', 'value' => 4, 'label' => $this->l('Footer')),
                            )
                        ),
                        // REKLAMA PRO 1 (Multi position)
                        array('type' => 'free', 'name' => 'pro_promo_1', 'label' => ''),

                        array(
                            'type' => 'text',
                            'label' => $this->l('Facebook Page URL'),
                            'name' => 'lbf_url',
                            'desc' => $this->l('The URL of the Facebook Page for LikeBox'),
                            'class' => 'fixed-width-xxl'
                        ),

                        // REKLAMA PRO 2 (Języki)
                        array('type' => 'free', 'name' => 'pro_promo_2', 'label' => ''),

                        array(
                            'type' => 'text',
                            'label' => $this->l('Width'),
                            'name' => 'lbf_width',
                            'desc' => $this->l('The width of the LikeBox plugin'),
                            'class' => 'fixed-width-sm'
                        ),
                        array(
                            'type' => 'text',
                            'label' => $this->l('Height'),
                            'name' => 'lbf_height',
                            'desc' => $this->l('The height of the LikeBox plugin'),
                            'class' => 'fixed-width-sm'
                        ),
                        array(
                            'type' => 'switch',
                            'label' => $this->l('Hide cover'),
                            'name' => 'lbf_hide_cover',
                            'is_bool' => true,
                            'desc' => $this->l('Hide cover photo in the header'),
                            'values' => $switch_values
                        ),
                        array(
                            'type' => 'switch',
                            'label' => $this->l('Profile pictures'),
                            'name' => 'lbf_show_facepile',
                            'is_bool' => true,
                            'desc' => $this->l('Show profile photos when friends like this'),
                            'values' => $switch_values
                        ),
                        array(
                            'type' => 'switch',
                            'label' => $this->l('Show posts'),
                            'name' => 'lbf_show_posts',
                            'is_bool' => true,
                            'desc' => $this->l('Show posts from the timeline.'),
                            'values' => $switch_values
                        ),
                        array(
                            'type' => 'switch',
                            'label' => $this->l('Call to action button'),
                            'name' => 'lbf_hide_cta',
                            'is_bool' => true,
                            'desc' => $this->l('Hide the custom call to action button (if available)'),
                            'values' => $switch_values
                        ),
                        array(
                            'type' => 'switch',
                            'label' => $this->l('Small header'),
                            'name' => 'lbf_small_header',
                            'is_bool' => true,
                            'desc' => $this->l('Use the small header instead'),
                            'values' => $switch_values
                        ),
                        array(
                            'type' => 'switch',
                            'label' => $this->l('Facebook library'),
                            'name' => 'lbf_includeapp',
                            'is_bool' => true,
                            'desc' => $this->l('Include facebook library sdk. Use this option if your shop doesnt use any facebook library.'),
                            'values' => $switch_values
                        ),

                        // REKLAMA PRO 3 (Responsywność, APP ID)
                        array('type' => 'free', 'name' => 'pro_promo_3', 'label' => '')
                    ),
                    'submit' => array(
                        'title' => $this->l('Save Settings'),
                        'class' => 'btn btn-default pull-right'
                    )
                )
            ),
            array(
                'form' => array(
                    'legend' => array(
                        'title' => $this->l('Likebox Preview'),
                        'icon' => 'icon-eye'
                    ),
                    'input' => array(
                        array('type' => 'free', 'name' => 'likebox_preview', 'label' => '')
                    )
                )
            )
        );

        $helper = new HelperForm();
        $helper->show_toolbar = false;
        $helper->table = $this->table;
        $helper->module = $this;
        $helper->default_form_language = $this->context->language->id;
        $helper->allow_employee_form_lang = Configuration::get('PS_BO_ALLOW_EMPLOYEE_FORM_LANG', 0);
        $helper->identifier = $this->identifier;
        $helper->submit_action = 'submit_settings';
        $helper->currentIndex = $this->context->link->getAdminLink('AdminModules', false) . '&configure=' . $this->name . '&tab_module=' . $this->tab . '&module_name=' . $this->name;
        $helper->token = Tools::getAdminTokenLite('AdminModules');
        $helper->tpl_vars = array(
            'fields_value' => $this->getConfigFieldsValues(),
            'languages' => $this->context->controller->getLanguages(),
            'id_language' => $this->context->language->id,
        );

        return $helper->generateForm($fields_form);
    }

    public function getConfigFieldsValues()
    {
        $values = array(
            'likeboxfree_position' => Configuration::get('likeboxfree_position'),
            'lbf_url'              => Configuration::get('lbf_url'),
            'lbf_width'            => Configuration::get('lbf_width'),
            'lbf_height'           => Configuration::get('lbf_height'),
            'lbf_hide_cover'       => Configuration::get('lbf_hide_cover'),
            'lbf_show_facepile'    => Configuration::get('lbf_show_facepile'),
            'lbf_show_posts'       => Configuration::get('lbf_show_posts'),
            'lbf_hide_cta'         => Configuration::get('lbf_hide_cta'),
            'lbf_small_header'     => Configuration::get('lbf_small_header'),
            'lbf_includeapp'       => Configuration::get('lbf_includeapp'),
        );

        // --- BLOKI PRO (Wizualna makieta opcji PRO w Bootstrapie) ---

        // PRO 1: Informacja o wielu pozycjach (dodane widoczne zablokowane checkboxy)
        $values['pro_promo_1'] = '<div style="position:relative; margin:0 -15px 15px -15px;">
            <div style="position:absolute; z-index:10; top:0; left:0; width:100%; height:100%; background:#fff; opacity:0.8;"></div>
            <div style="position:absolute; z-index:11; top:35px; width:100%; text-align:center;">
                ' . $this->l('To display like box in various positions at the same time - ') . '<br/>
                ' . $this->l('This option available only in commercial version of the module') . '<br/>
                <a href="https://mypresta.eu/modules/social-networks/responsive-facebook-like-box.html" target="_blank"><strong>Responsive Facebook Like Box</strong></a>
            </div>
            
            <div class="form-group">
                <label class="control-label col-lg-3">' . $this->l('Multiple positions') . '</label>
                <div class="col-lg-9">
                    <div class="checkbox"><label><input type="checkbox" disabled="disabled" checked="checked"> ' . $this->l('Left column') . '</label></div>
                    <div class="checkbox"><label><input type="checkbox" disabled="disabled" checked="checked"> ' . $this->l('Right column') . '</label></div>
                    <div class="checkbox"><label><input type="checkbox" disabled="disabled"> ' . $this->l('Homepage') . '</label></div>
                    <div class="checkbox"><label><input type="checkbox" disabled="disabled"> ' . $this->l('Footer') . '</label></div>
                    <p class="help-block">' . $this->l('Select multiple positions where you want to display the Likebox simultaneously.') . '</p>
                </div>
            </div>
        </div>';

        // PRO 2: Języki (widoczne fałszywe pole)
        $values['pro_promo_2'] = '<div style="position:relative; margin:0 -15px 15px -15px;">
            <div style="position:absolute; z-index:10; top:0; left:0; width:100%; height:100%; background:#fff; opacity:0.8;"></div>
            <div style="position:absolute; z-index:11; top:20px; width:100%; text-align:center;">
                ' . $this->l('Option available only in commercial version of the module') . '<br/>
                <a href="https://mypresta.eu/modules/social-networks/responsive-facebook-like-box.html" target="_blank"><strong>Responsive Facebook Like Box</strong></a>
            </div>
            <div class="form-group">
                <label class="control-label col-lg-3">' . $this->l('Like box language versions') . '</label>
                <div class="col-lg-9">
                    <div class="row">
                        <div class="col-lg-2">
                            <input type="text" disabled="disabled" value="en_US" class="form-control" />
                        </div>
                    </div>
                    <p class="help-block">' . $this->l('read more about language codes') . '</p>
                </div>
            </div>
        </div>';

        // PRO 3: Responsywność, Bootstrap, APP ID (widoczne fałszywe przełączniki)
        $values['pro_promo_3'] = '<div style="position:relative; margin:20px -15px 0 -15px;">
            <div style="position:absolute; z-index:10; top:0; left:0; width:100%; height:100%; background:#fff; opacity:0.8;"></div>
            <div style="position:absolute; z-index:11; top:50px; width:100%; text-align:center;">
                ' . $this->l('Option available only in commercial version of the module') . '<br/>
                <a href="https://mypresta.eu/modules/social-networks/responsive-facebook-like-box.html" target="_blank"><strong>Responsive Facebook Like Box</strong></a>
            </div>
            
            <div class="form-group">
                <label class="control-label col-lg-3">' . $this->l('Turn on responsiveness') . '</label>
                <div class="col-lg-9">
                    <span class="switch prestashop-switch fixed-width-lg">
                        <input type="radio" disabled="disabled"><label>' . $this->l('Yes') . '</label>
                        <input type="radio" disabled="disabled" checked="checked"><label>' . $this->l('No') . '</label>
                        <a class="slide-button btn"></a>
                    </span>
                    <p class="help-block">' . $this->l('Try to fit inside the container width. To use this option empty "width" input box. min width is 180 - max width of facebook like box is 500px') . '</p>
                </div>
            </div>
            
            <div class="form-group">
                <label class="control-label col-lg-3">' . $this->l('Default bootstrap support') . '</label>
                <div class="col-lg-9">
                    <span class="switch prestashop-switch fixed-width-lg">
                        <input type="radio" disabled="disabled"><label>' . $this->l('Yes') . '</label>
                        <input type="radio" disabled="disabled" checked="checked"><label>' . $this->l('No') . '</label>
                        <a class="slide-button btn"></a>
                    </span>
                    <p class="help-block">' . $this->l('Module will like default bootstrap facebook fan block') . '</p>
                </div>
            </div>
            
            <div class="form-group"> 
                <label class="control-label col-lg-3">' . $this->l('Facebook APP ID') . '</label>
                <div class="col-lg-9">
                    <input type="text" disabled="disabled" class="form-control" style="width:400px;" />
                    <p class="help-block">' . $this->l('Enter here APP ID associated with your shop domain') . '</p>
                </div>
            </div>
        </div>';

        // Kod podglądu LikeBoxa
        $values['likebox_preview'] = '<div id="likeboxpreview" style="text-align:left;">
            <div id="fb-root"></div>
            <script>(function(d, s, id) {
              var js, fjs = d.getElementsByTagName(s)[0];
              if (d.getElementById(id)) return;
              js = d.createElement(s); js.id = id;
              js.src = "//connect.facebook.net/en_US/sdk.js#xfbml=1&version=v2.3";
              fjs.parentNode.insertBefore(js, fjs);
            }(document, \'script\', \'facebook-jssdk\'));</script>
            <div class="fb-page" data-width="' . Configuration::get('lbf_width') . '" data-height="' . Configuration::get('lbf_height') . '" data-href="' . Configuration::get('lbf_url') . '" data-small-header="' . (Configuration::get('lbf_small_header') == 1 ? 'true' : 'false') . '" data-hide-cta="' . (Configuration::get('lbf_hide_cta') == 1 ? 'true' : 'false') . '" data-hide-cover="' . (Configuration::get('lbf_hide_cover') == 1 ? 'true' : 'false') . '" data-show-facepile="' . (Configuration::get('lbf_show_facepile') == 1 ? 'true' : 'false') . '" data-show-posts="' . (Configuration::get('lbf_show_posts') == 1 ? 'true' : 'false') . '"><div class="fb-xfbml-parse-ignore"><blockquote cite="' . Configuration::get('lbf_url') . '"><a href="' . Configuration::get('lbf_url') . '"></a></blockquote></div></div>
        </div>';

        return $values;
    }


    public function setlikeboxoptions()
    {
        $likebox_showstream_checked = "0";
        $likebox_showheader_checked = "0";
        $likebox_showfaces_checked = "0";
        $likebox_fanpageurl = Configuration::get('likeboxfree_fanpageurl');
        $likebox_width = Configuration::get('likeboxfree_width');
        $likebox_height = Configuration::get('likeboxfree_height');
        $likebox_colorscheme = Configuration::get('likeboxfree_colorscheme');
        if ($likebox_colorscheme == "light")
        {
            $selected_light = "SELECTED";
            $selected_dark = "";
            $likebox_colorscheme_bg = "white";
        }
        if ($likebox_colorscheme == "dark")
        {
            $selected_dark = "SELECTED";
            $selected_light = "";
            $likebox_colorscheme_bg = "black";
        }
        $likebox_showfaces = Configuration::get('likeboxfree_showfaces');
        if ($likebox_showfaces == "1")
        {
            $likebox_showfaces_checked = "checked='YES'";
        }
        $likebox_bordercolor = Configuration::get('likeboxfree_bordercolor');
        $likebox_showstream = Configuration::get('likeboxfree_showstream');
        if ($likebox_showstream == "1")
        {
            $likebox_showstream_checked = "checked='YES'";
        }
        $likebox_showheader = Configuration::get('likeboxfree_showheader');
        if ($likebox_showheader == "1")
        {
            $likebox_showheader_checked = "checked='YES'";
        }

        $likebox_bgon = Configuration::get('likeboxfree_bgon');
        $likebox_bgcolor = Configuration::get('likeboxfree_bgcolor');

        $array['likeboxfree_fanpageurl'] = $likebox_fanpageurl;
        $array['likeboxfree_width'] = $likebox_width;
        $array['likeboxfree_height'] = $likebox_height;
        $array['likeboxfree_colorscheme'] = $likebox_colorscheme;
        $array['likeboxfree_showfaces'] = $likebox_showfaces;
        $array['likeboxfree_showheader'] = $likebox_showheader;
        $array['likeboxfree_showstream'] = $likebox_showstream;
        $array['likeboxfree_bordercolor'] = $likebox_bordercolor;
        $array['likeboxfree_bgcolor'] = $likebox_bgcolor;
        $array['likeboxfree_bgon'] = $likebox_bgon;
        return $array;
    }

    function hookdisplayRightColumn($params)
    {
        if (Configuration::get('likeboxfree_position') == 2)
        {
            $likeboxarray = $this->setlikeboxoptions();
            global $smarty;
            $smarty->assign(array('likebox' => $likeboxarray));
            return $this->display(__FILE__, 'rightcolumn.tpl');
        }
    }

    function hookdisplayLeftColumn($params)
    {

        if (Configuration::get('likeboxfree_position') == 1)
        {
            $likeboxarray = $this->setlikeboxoptions();
            global $smarty;
            $smarty->assign(array('likebox' => $likeboxarray));
            return $this->display(__FILE__, 'rightcolumn.tpl');
        }
    }

    function hookdisplayHome($params)
    {
        if (Configuration::get('likeboxfree_position') == 3)
        {
            $likeboxarray = $this->setlikeboxoptions();
            global $smarty;
            $smarty->assign(array('likebox' => $likeboxarray));
            return $this->display(__FILE__, 'rightcolumn.tpl');
        }
    }

    function hookdisplayFooter($params)
    {
        if (Configuration::get('likeboxfree_position') == 4)
        {
            $likeboxarray = $this->setlikeboxoptions();
            global $smarty;
            $smarty->assign(array('likebox' => $likeboxarray));
            return $this->display(__FILE__, 'rightcolumn.tpl');
        }
    }
}



class likeboxfreeUpdate extends likeboxfree
{
    public static function version($version)
    {
        $version = (int)str_replace(".", "", $version);
        if (strlen($version) == 3)
        {
            $version = (int)$version . "0";
        }
        if (strlen($version) == 2)
        {
            $version = (int)$version . "00";
        }
        if (strlen($version) == 1)
        {
            $version = (int)$version . "000";
        }
        if (strlen($version) == 0)
        {
            $version = (int)$version . "0000";
        }
        return (int)$version;
    }

    public static function encrypt($string)
    {
        return base64_encode($string);
    }

    public static function verify($module, $key, $version)
    {
        if (ini_get("allow_url_fopen"))
        {
            if (function_exists("file_get_contents"))
            {
                $actual_version = @file_get_contents('http://dev.mypresta.eu/update/get.php?module=' . $module . "&version=" . self::encrypt($version) . "&lic=$key&u=" . self::encrypt(_PS_BASE_URL_ . __PS_BASE_URI__));
            }
        }
        Configuration::updateValue("update_" . $module, date("U"));
        Configuration::updateValue("updatev_" . $module, $actual_version);
        return $actual_version;
    }
}

?>