<?php
/**
 * PrestaShop module created by VEKIA, a guy from official PrestaShop community ;-)
 *
 * @author    VEKIA PL MILOSZ MYSZCZUK VATEU: PL9730945634
 * @copyright 2010-2026 VEKIA
 * @license   This program is not free software and you can't resell and redistribute it
 *
 * CONTACT WITH DEVELOPER http://mypresta.eu
 * support@mypresta.eu
 */

if (!defined('_PS_VERSION_')) {
    exit;
}

use PrestaShop\PrestaShop\Adapter\Image\ImageRetriever;
use PrestaShop\PrestaShop\Adapter\Product\PriceFormatter;
use PrestaShop\PrestaShop\Adapter\Presenter\Product\ProductListingPresenter;
use PrestaShop\PrestaShop\Adapter\Product\ProductColorsRetriever;

/**
 * Main module class. featuredcategoryUpdate (updateChecker.php) extends this.
 */
class featuredcategory extends Module
{
    /** @var string Link to the module's official website */
    public $mypresta_link;

    /** @var array|null Cached products for performance */
    protected static $cache_products;

    public function __construct()
    {
        $this->name = 'featuredcategory';
        $this->tab = 'front_office_features';
        $this->version = '1.8.0';
        $this->author = 'MyPresta.eu';
        $this->module_key = '608d1b2b57fb8cd01763efb2abe6ca35';
        $this->bootstrap = true;
        $this->mypresta_link = 'https://mypresta.eu/modules/front-office-features/featured-products-from-category.html';

        parent::__construct();

        $this->displayName = $this->l('Featured category products on the homepage');
        $this->description = $this->l('Displays featured products from a selected category in the central column of your homepage or as a tab.');

        if (!($this instanceof featuredcategoryUpdate)) {
            (new featuredcategoryUpdate())->runUpdateSetUp();
        }
    }

    public function checkforupdates($display_msg = 0, $form = 0)
    {
        return (new featuredcategoryUpdate())->checkforupdates($display_msg, $form);
    }

    public function inconsistency()
    {
        return (new featuredcategoryUpdate())->inconsistency();
    }

    /**
     * Installs the module and registers necessary hooks.
     *
     * @return bool
     */
    public function install()
    {
        $this->_clearCache('*');
        Configuration::updateValue('CFEATURED_NBR', 8);
        Configuration::updateValue('mypresta_updates', 1);

        return parent::install() &&
            $this->registerHook('displayHeader') &&
            $this->registerHook('actionProductAdd') &&
            $this->registerHook('actionProductUpdate') &&
            $this->registerHook('actionProductDelete') &&
            $this->registerHook('actionCategoryUpdate') &&
            $this->registerHook('displayHomeTab') &&
            $this->registerHook('displayHomeTabContent') &&
            $this->registerHook('displayHome');
    }

    /**
     * Uninstalls the module.
     *
     * @return bool
     */
    public function uninstall()
    {
        $this->_clearCache('*');
        return parent::uninstall();
    }

    /**
     * Handles the module configuration page in Back Office.
     *
     * @return string
     */
    public function getContent()
    {
        $output = '';
        $errors = array();

        if (Tools::isSubmit('submitCategoryFeatured')) {
            Configuration::updateValue('CFEATURED_ID', (int)Tools::getValue('CFEATURED_ID'));
            Configuration::updateValue('CFEATURED_WHERE', (int)Tools::getValue('CFEATURED_WHERE'));
            $nbr = (int)Tools::getValue('CFEATURED_NBR');

            if (!$nbr || $nbr <= 0) {
                $output .= $this->displayError($this->l('An invalid number of products has been specified. Please use a positive number.'));
            } else {
                Configuration::updateValue('CFEATURED_NBR', $nbr);
                $this->_clearCache('*');
                $output .= $this->displayConfirmation($this->l('Your settings have been updated successfully.'));
            }
        }

        return $output . $this->advert() . $this->renderForm() . $this->checkforupdates(0, 1);
    }

    /**
     * Renders external information frame.
     *
     * @return string
     */
    public function advert()
    {
        return '<iframe src="//dev.addons.ovh/modules.html?module=' . $this->name . '" width="100%" height="150" border="0" style="border:none;"></iframe>';
    }

    /**
     * Adds CSS to the header.
     *
     * @param array $params
     */
    public function hookDisplayHeader($params)
    {
        $this->context->controller->addCSS(($this->_path) . 'featuredcategory.css', 'all');
    }

    /**
     * Prepares products for PS 1.7 / 8 / 9 templates using the Presenter API.
     *
     * @param array $products Raw product list.
     * @return array Presented products.
     */
    public function prepareBlocksProducts($products)
    {
        if (empty($products)) {
            return array();
        }

        $assembler = new ProductAssembler($this->context);
        $presenterFactory = new ProductPresenterFactory($this->context);
        $presentationSettings = $presenterFactory->getPresentationSettings();
        $presenter = new ProductListingPresenter(
            new ImageRetriever($this->context->link),
            $this->context->link,
            new PriceFormatter(),
            new ProductColorsRetriever(),
            $this->context->getTranslator()
        );

        $products_for_template = array();
        foreach ($products as $rawProduct) {
            $products_for_template[] = $presenter->present(
                $presentationSettings,
                $assembler->assembleProduct($rawProduct),
                $this->context->language
            );
        }

        return $products_for_template;
    }

    /**
     * Hook to display the tab title.
     *
     * @return string|null
     */
    public function hookDisplayHomeTab($params)
    {
        if (Configuration::get('CFEATURED_WHERE') == 1) {
            return $this->display(__FILE__, 'views/templates/hook/tab.tpl');
        }
    }

    /**
     * Hook to display the products inside a tab.
     *
     * @return string|null
     */
    public function hookDisplayHomeTabContent($params)
    {
        if (Configuration::get('CFEATURED_WHERE') == 1) {
            $this->assignProducts();
            return $this->context->smarty->fetch('module:featuredcategory/views/templates/hook/featuredcategory17-tabContents.tpl');
        }
    }

    /**
     * Hook to display products in a standard block on the homepage.
     *
     * @return string|null
     */
    public function hookDisplayHome($params)
    {
        if (Configuration::get('CFEATURED_WHERE') == 2) {
            $this->assignProducts();
            return $this->context->smarty->fetch('module:featuredcategory/views/templates/hook/featuredcategory17.tpl');
        }
    }

    /**
     * Internal helper to fetch products and assign them to Smarty.
     */
    protected function assignProducts()
    {
        $id_category = (int)Configuration::get('CFEATURED_ID');
        $nb = (int)Configuration::get('CFEATURED_NBR');
        $category = new Category($id_category, $this->context->language->id);

        $products = $category->getProducts($this->context->language->id, 1, ($nb ? $nb : 8), 'position');

        $this->context->smarty->assign(array(
            'products' => $this->prepareBlocksProducts($products),
            'productClasses' => 'col-xs-12 col-sm-6 col-xl-3'
        ));
    }

    /**
     * Generates the module configuration form.
     *
     * @return string
     */
    public function renderForm()
    {
        $fields_form = array(
            'form' => array(
                'legend' => array('title' => $this->l('Settings'), 'icon' => 'icon-cogs'),
                'input' => array(
                    array(
                        'type' => 'text',
                        'label' => $this->l('Source Category ID'),
                        'name' => 'CFEATURED_ID',
                        'class' => 'fixed-width-xs',
                        'required' => true,
                        'desc' => $this->l('Provide the ID of the category from which products will be fetched. This allows you to specifically target a group of items to showcase on your front page.'),
                    ),
                    array(
                        'type' => 'text',
                        'label' => $this->l('Number of Products'),
                        'name' => 'CFEATURED_NBR',
                        'class' => 'fixed-width-xs',
                        'required' => true,
                        'desc' => $this->l('Set the total amount of products you wish to display. A count of 8 is standard for maintaining an aesthetic grid across most devices.'),
                    ),
                    array(
                        'type' => 'select',
                        'label' => $this->l('Placement Position'),
                        'name' => 'CFEATURED_WHERE',
                        'required' => true,
                        'desc' => $this->l('Choose where the module should appear. "Homepage Tabs" will place the product list inside your theme\'s tab system, while "Homepage" renders it as a separate section.'),
                        'options' => array(
                            'query' => array(
                                array('id' => 1, 'name' => $this->l('Homepage Tabs')),
                                array('id' => 2, 'name' => $this->l('Standard Homepage Section')),
                            ),
                            'id' => 'id',
                            'name' => 'name'
                        ),
                    ),
                ),
                'submit' => array('title' => $this->l('Save Configuration'), 'class' => 'btn btn-default pull-right')
            ),
        );

        $helper = new HelperForm();
        $helper->module = $this;
        $helper->token = Tools::getAdminTokenLite('AdminModules');
        $helper->currentIndex = AdminController::$currentIndex . '&configure=' . $this->name;
        $helper->default_form_language = $this->context->language->id;
        $helper->submit_action = 'submitCategoryFeatured';
        $helper->tpl_vars = array(
            'fields_value' => array(
                'CFEATURED_NBR' => Configuration::get('CFEATURED_NBR'),
                'CFEATURED_ID' => Configuration::get('CFEATURED_ID'),
                'CFEATURED_WHERE' => Configuration::get('CFEATURED_WHERE'),
            ),
            'languages' => $this->context->controller->getLanguages(),
            'id_language' => $this->context->language->id
        );

        return $helper->generateForm(array($fields_form));
    }

    public function _clearCache($template, $cache_id = null, $compile_id = null)
    {
        parent::_clearCache('featuredcategory17.tpl');
        parent::_clearCache('featuredcategory17-tabContents.tpl');
        parent::_clearCache('tab.tpl');
    }

    public function hookActionProductAdd($params) { $this->_clearCache('*'); }
    public function hookActionProductUpdate($params) { $this->_clearCache('*'); }
    public function hookActionProductDelete($params) { $this->_clearCache('*'); }
    public function hookActionCategoryUpdate($params) { $this->_clearCache('*'); }
}

require_once dirname(__FILE__) . '/updateChecker.php';