<?php
/**
 * PrestaShop module created by VEKIA, a guy from official PrestaShop community ;-)
 *
 * @author    VEKIA https://www.prestashop.com/forums/user/132608-vekia/
 * @copyright 2010-2020 VEKIA
 * @license   This program is not free software and you can't resell and redistribute it
 *
 * CONTACT WITH DEVELOPER http://mypresta.eu
 * support@mypresta.eu
 */

if (!defined('_PS_VERSION_'))
{
    exit;
}

class boproductfinder extends Module
{

    public $mypresta_link;
    public function __construct()
    {
        $this->name = 'boproductfinder';
        $this->tab = 'administration';
        $this->version = '1.2.5';
        $this->author = 'MyPresta.eu';
        $this->mypresta_link = 'https://mypresta.eu/modules/administration-tools/back-office-ajax-product-search.html';
        $this->bootstrap = true;
        parent::__construct();

        $this->displayName = $this->l('Back office ajax product filter');
        $this->description = $this->l('Module allows to use quick filter tool to search products with AJAX method');
        $this->checkforupdates();
    }

    public static function psversion($part = 1)
    {
        $version = _PS_VERSION_;
        $exp = explode('.', $version);
        if ($part == 0) {
            return $exp[0];
        }
        if ($part == 1) {
            if ($exp[0] >= 8) {
                return 7;
            }
            return $exp[1];
        }
        if ($part == 2) {
            return $exp[2];
        }
        if ($part == 3) {
            return $exp[3];
        }
    }

    public function checkforupdates($display_msg = 0, $form = 0)
    {
        // ---------- //
        // ---------- //
        // VERSION 16 //
        // ---------- //
        // ---------- //
        $this->mkey = "nlc";
        if (@file_exists('../modules/' . $this->name . '/key.php')) {
            @require_once('../modules/' . $this->name . '/key.php');
        } else {
            if (@file_exists(dirname(__FILE__) . $this->name . '/key.php')) {
                @require_once(dirname(__FILE__) . $this->name . '/key.php');
            } else {
                if (@file_exists('modules/' . $this->name . '/key.php')) {
                    @require_once('modules/' . $this->name . '/key.php');
                }
            }
        }
        if ($form == 1) {
            return '
            <div class="panel" id="fieldset_myprestaupdates" style="margin-top:20px;">
            ' . ($this->psversion() == 6 || $this->psversion() == 7 ||  (version_compare(_PS_VERSION_, '8.0.0', '>=')) ? '<div class="panel-heading"><i class="icon-wrench"></i> ' . $this->l('MyPresta updates') . '</div>' : '') . '
			<div class="form-wrapper" style="padding:20px!important;">
            <div id="module_block_settings">
                    <fieldset id="fieldset_module_block_settings">
                         ' . ($this->psversion() == 5 ? '<legend style="">' . $this->l('MyPresta updates') . '</legend>' : '') . '
                        <form action="' . $_SERVER['REQUEST_URI'] . '" method="post">
                            <label>' . $this->l('Check updates') . '</label>
                            <div class="margin-form">' . (Tools::isSubmit('submit_settings_updates_now') ? ($this->inconsistency(0) ? '' : '') . $this->checkforupdates(1) : '') . '
                                <button style="margin: 0px; top: -3px; position: relative;" type="submit" name="submit_settings_updates_now" class="button btn btn-default" />
                                <i class="process-icon-update"></i>
                                ' . $this->l('Check now') . '
                                </button>
                            </div>
                            <label>' . $this->l('Updates notifications') . '</label>
                            <div class="margin-form">
                                <select name="mypresta_updates">
                                    <option value="-">' . $this->l('-- select --') . '</option>
                                    <option value="1" ' . ((int)(Configuration::get('mypresta_updates') == 1) ? 'selected="selected"' : '') . '>' . $this->l('Enable') . '</option>
                                    <option value="0" ' . ((int)(Configuration::get('mypresta_updates') == 0) ? 'selected="selected"' : '') . '>' . $this->l('Disable') . '</option>
                                </select>
                                <p class="clear">' . $this->l('Turn this option on if you want to check MyPresta.eu for module updates automatically. This option will display notification about new versions of this addon.') . '</p>
                            </div>
                            <label>' . $this->l('Module page') . '</label>
                            <div class="margin-form">
                                <a style="font-size:14px;" href="' . $this->mypresta_link . '" target="_blank">' . $this->displayName . '</a>
                                <p class="clear">' . $this->l('This is direct link to official addon page, where you can read about changes in the module (changelog)') . '</p>
                            </div>
                            <div class="panel-footer">
                                <button type="submit" name="submit_settings_updates"class="button btn btn-default pull-right" />
                                <i class="process-icon-save"></i>
                                ' . $this->l('Save') . '
                                </button>
                            </div>
                        </form>
                    </fieldset>
                    <style>
                    #fieldset_myprestaupdates {
                        display:block;clear:both;
                        float:inherit!important;
                    }
                    </style>
                </div>
            </div>
            </div>';
        } else {
            if (defined('_PS_ADMIN_DIR_')) {
                if (Tools::isSubmit('submit_settings_updates')) {
                    Configuration::updateValue('mypresta_updates', Tools::getValue('mypresta_updates'));
                }
                if (Configuration::get('mypresta_updates') != 0 || (bool)Configuration::get('mypresta_updates') != false) {
                    if (Configuration::get('update_' . $this->name) < (date("U") - 259200)) {
                        $actual_version = boproductfinderUpdate::verify($this->name, (isset($this->mkey) ? $this->mkey : 'nokey'), $this->version);
                    }
                    if (boproductfinderUpdate::version($this->version) < boproductfinderUpdate::version(Configuration::get('updatev_' . $this->name)) && Tools::getValue('ajax', 'false') == 'false') {
                        $this->context->controller->warnings[] = '<strong>' . $this->displayName . '</strong>: ' . $this->l('New version available, check http://MyPresta.eu for more informations') . ' <a href="' . $this->mypresta_link . '">' . $this->l('More details in changelog') . '</a>';
                        $this->warning = $this->context->controller->warnings[0];
                    }
                } else {
                    if (Configuration::get('update_' . $this->name) < (date("U") - 259200)) {
                        $actual_version = boproductfinderUpdate::verify($this->name, (isset($this->mkey) ? $this->mkey : 'nokey'), $this->version);
                    }
                }
                if ($display_msg == 1) {
                    if (boproductfinderUpdate::version($this->version) < boproductfinderUpdate::version(boproductfinderUpdate::verify($this->name, (isset($this->mkey) ? $this->mkey : 'nokey'), $this->version))) {
                        return "<span style='color:red; font-weight:bold; font-size:16px; margin-right:10px;'>" . $this->l('New version available!') . "</span>";
                    } else {
                        return "<span style='color:green; font-weight:bold; font-size:16px; margin-right:10px;'>" . $this->l('Module is up to date!') . "</span>";
                    }
                }
            }
        }
    }

    public function inconsistency($ret)
    {
        return;
    }
    public function install()
    {
        if (!parent::install() || !$this->registerHook('actionAdminControllerSetMedia') || !$this->registerHook('displayBackOfficeHeader'))
        {
            return false;
        }
        return true;
    }
    public function displayInformationMessage()
    {
        $msg = '<strong>' . $this->l('Product Search & Fast Navigation Module:') . '</strong> ';
        $msg .= $this->l('Optimize your back-office workflow with our advanced product lookup tool.') . ' ';
        $msg .= $this->l('This module enables administrative users to perform real-time searches by product name, leveraging an intuitive autocomplete suggestion system.') . ' ';
        $msg .= $this->l('Instantly identify the correct inventory item from the dropdown list and benefit from direct redirection to the comprehensive product configuration page, streamlining your catalog management and reducing operational search time.') . ' ';

        $msg .= '<br /><br /><strong>' . $this->l('Ease of Use:') . '</strong> ';
        $msg .= $this->l("This is a 100% 'Plug and Play' solution that requires no additional configuration.") . ' ';
        $msg .= $this->l('Once the installation is complete, the autocomplete search feature will be automatically active and available directly on the product list page under Catalog > Products in your admin panel.');

        $this->informations[] = $msg;
    }

    public function getContent()
    {
        $this->displayInformationMessage();
        if (Tools::getValue('ajax', 'false') != 'false') {
            $query = Tools::getValue('q', false);
            if ( ! $query or $query == '' or strlen($query) < 1) {
                die();
            }

            if ($pos = strpos($query, ' (ref:')) {
                $query = substr($query, 0, $pos);
            }

            $excludeIds = Tools::getValue('excludeIds', false);
            if ($excludeIds && $excludeIds != 'NaN') {
                $excludeIds = implode(',', array_map('intval', explode(',', $excludeIds)));
            } else {
                $excludeIds        = '';
                $excludePackItself = Tools::getValue('packItself', false);
            }

            $excludeVirtuals = (bool)Tools::getValue('excludeVirtuals', true);
            $exclude_packs   = (bool)Tools::getValue('exclude_packs', true);

            $context = Context::getContext();

            $sql = 'SELECT p.`id_product`, pl.`link_rewrite`, p.`reference`, pl.`name`, image_shop.`id_image` id_image, il.`legend`, p.`cache_default_attribute`
            FROM `' . _DB_PREFIX_ . 'product` p
            ' . Shop::addSqlAssociation('product', 'p') . '
            LEFT JOIN `' . _DB_PREFIX_ . 'product_lang` pl ON (pl.id_product = p.id_product AND pl.id_lang = ' . (int)$context->language->id . Shop::addSqlRestrictionOnLang('pl') . ')
            LEFT JOIN `' . _DB_PREFIX_ . 'image_shop` image_shop
                ON (image_shop.`id_product` = p.`id_product` AND image_shop.cover=1 AND image_shop.id_shop=' . (int)$context->shop->id . ')
            LEFT JOIN `' . _DB_PREFIX_ . 'image_lang` il ON (image_shop.`id_image` = il.`id_image` AND il.`id_lang` = ' . (int)$context->language->id . ')
            WHERE (pl.name LIKE \'%' . pSQL($query) . '%\' OR p.reference LIKE \'%' . pSQL($query) . '%\')' . (! empty($excludeIds) ? ' AND p.id_product NOT IN (' . $excludeIds . ') ' : ' ') . (! empty($excludePackItself) ? ' AND p.id_product <> ' . $excludePackItself . ' ' : ' ') . ($excludeVirtuals ? 'AND NOT EXISTS (SELECT 1 FROM `' . _DB_PREFIX_ . 'product_download` pd WHERE (pd.id_product = p.id_product))' : '') . ($exclude_packs ? 'AND (p.cache_is_pack IS NULL OR p.cache_is_pack = 0)' : '') . ' GROUP BY p.id_product';

            $items = Db::getInstance()->executeS($sql);

            if ($items && ($excludeIds)) {
                foreach ($items as $item) {
                    $item['name'] = str_replace('|', '&#124;', $item['name']);
                    $item['url'] = Context::getContext()->link->getAdminLink('AdminProducts', true,
                        [
                            'route' => 'admin_products_edit',
                            'productId' => $item['id_product'],
                        ]);
                    echo trim($item['name']) . (! empty($item['reference']) ? ' (ref: ' . $item['reference'] . ')' : '') . '|' . (int)($item['id_product']) . '|' . self::getImagesByID($item['link_rewrite'], (int)($item['id_product']))."|".$item['url']."\n";
                }
            }
            die();
        } else {
            return $this->checkforupdates(0,1);
        }
    }

    public static function getImagesByID($link_rewrite, $id_product)
    {
        $limit = 1;
        $id_image = Db::getInstance()->ExecuteS('SELECT `id_image` FROM `' . _DB_PREFIX_ . 'image` WHERE cover=1 AND `id_product` = ' . (int)$id_product . ' ORDER BY position ASC LIMIT 0, ' . (int)$limit);
        $toReturn = array();
        if (!$id_image)
        {
            return;
        }
        else
        {
            foreach ($id_image as $image)
            {
                $toReturn = Context::getContext()->link->getImageLink($link_rewrite, $id_product . '-' . $image['id_image'], 'small_default');
            }
        }
        return $toReturn;
    }

    public function hookDisplayBackOfficeHeader()
    {
        return '<script>
				var admin_module_edit_url = \''.$this->context->link->getAdminLink('AdminModules').'\';
			</script>';
    }

    public function hookactionAdminControllerSetMedia()
    {

        $this->context->controller->addJs($this->_path . 'views/boproductfinder.js');
        $this->context->controller->addJs($this->_path . 'views/autocomplete.js');
        $this->context->controller->addCss($this->_path . 'views/autocomplete.css');
    }
}

class boproductfinderUpdate extends boproductfinder
{
    public static function version($version)
    {
        $version = (int)str_replace(".", "", $version);
        if (strlen($version) == 4) {
            $version = (int)$version . "0";
        }
        if (strlen($version) == 3) {
            $version = (int)$version . "00";
        }
        if (strlen($version) == 2) {
            $version = (int)$version . "000";
        }
        if (strlen($version) == 1) {
            $version = (int)$version . "0000";
        }
        if (strlen($version) == 0) {
            $version = (int)$version . "00000";
        }
        return (int)$version;
    }

    public static function encrypt($string)
    {
        return base64_encode($string);
    }

    public static function verify($module, $key, $version)
    {
        if (ini_get("allow_url_fopen")) {
            if (function_exists("file_get_contents")) {
                $actual_version = @file_get_contents('http://dev.mypresta.eu/update/get.php?module=' . $module . "&version=" . self::encrypt($version) . "&lic=$key&u=" . self::encrypt(_PS_BASE_URL_ . __PS_BASE_URI__));
            }
        }
        Configuration::updateValue("update_" . $module, date("U"));
        Configuration::updateValue("updatev_" . $module, $actual_version);
        return $actual_version;
    }
}
