<?php
/**
 * PrestaShop module created by VEKIA, a guy from official PrestaShop community ;-)
 *
 * @author    VEKIA PL VATEU: PL9730945634
 * @copyright 2010-2025 VEKIA
 * @license   This program is not free software and you can't resell and redistribute it
 *
 * CONTACT WITH DEVELOPER http://mypresta.eu
 * support@mypresta.eu
 */

require_once(dirname(__FILE__) . '../../../models/aapfree_question.php');
require_once(dirname(__FILE__) . '../../../aapfree.php');

class AdminAapfreeQuestionController extends ModuleAdminController
{
    public function __construct()
    {
        $this->table = 'aapfreequestion';
        $this->className = 'aapfreeQuestion';
        $this->lang = false;
        $this->addRowAction('delete');

        parent::__construct();
        $this->bulk_actions = array(
            'delete' => array(
                'text' => $this->module->l('Delete selected','adminaapfreequestion'),
                'confirm' => $this->module->l('Delete selected items?','adminaapfreequestion')
            )
        );
        $this->bootstrap = true;
        $this->_orderBy = 'id_aapfreequestion';
        $this->_group = 'GROUP BY a.id_aapfreequestion';
        $this->list_no_link = true;
        $this->fields_list = array(
            'id_aapfreequestion' => array(
                'title' => $this->module->l('ID','adminaapfreequestion'),
                'align' => 'left',
                'orderby' => true,
                'width' => 30
            ),
            'author' => array(
                'title' => $this->module->l('Author','adminaapfreequestion'),
                'align' => 'left',
                'hint' => $this->module->l('Question\'s author name','adminaapfreequestion'),
                'orderby' => true,
            ),
            'email' => array(
                'title' => $this->module->l('Email','adminaapfreequestion'),
                'align' => 'left',
                'hint' => $this->module->l('Email of customer that submitted question','adminaapfreequestion'),
                'orderby' => true,
            ),
            'phone' => array(
                'title' => $this->module->l('Phone','adminaapfreequestion'),
                'align' => 'left',
                'orderby' => true,
            ),
            'id_product' => array(
                'title' => $this->module->l('Product','adminaapfreequestion'),
                'align' => 'left',
                'orderby' => true,
            ),
            'id_combination' => array(
                'title' => $this->module->l('Combination','adminaapfreequestion'),
                'align' => 'left',
                'orderby' => true,
            ),
            'question' => array(
                'title' => $this->module->l('Question','adminaapfreequestion'),
                'align' => 'left',
                'orderby' => true,
            ),
        );
    }

    public function renderForm()
    {

        $obj = $this->loadObject(true);
        if (isset($obj->id)) {
            $this->display = 'edit';
        } else {
            $this->display = 'add';
        }

        $this->fields_form = array(
            'legend' => array(
                'title' => $this->module->l('Unsubscription from reminders','adminaapfreequestion'),
            ),
            'input' => array(
                array(
                    'type' => 'text',
                    'label' => $this->module->l('Email of customer','adminaapfreequestion'),
                    'name' => 'email',
                    'required' => true,
                    'lang' => false,
                ),
                array(
                    'type' => 'text',
                    'label' => $this->module->l('IP','adminaapfreequestion'),
                    'name' => 'ip',
                    'required' => true,
                    'lang' => false,
                ),
                array(
                    'type' => 'datetime',
                    'label' => $this->module->l('Date','adminaapfreequestion'),
                    'name' => 'unsub_date',
                    'required' => true,
                ),
            ),

            'submit' => array(
                'title' => $this->module->l('Save','adminaapfreequestion')
            )
        );
        return parent::renderForm();
    }
}