<?php
/**
 * PrestaShop module created by VEKIA, a guy from official PrestaShop community ;-)
 *
 * @author    VEKIA PL MILOSZ MYSZCZUK VATEU: PL9730945634
 * @copyright 2010-9999 VEKIA
 * @license   This program is not free software and you can't resell and redistribute it
 *
 *  CONTACT WITH DEVELOPER http://mypresta.eu
 *  support@mypresta.eu
 *
 * prestashop 9 compatibility package for prestashop modules by MYPRESTA.EU
 * version: 1.5.0
 *
 * [CONSTANTS]
 * _PS_PRICE_DISPLAY_PRECISION_
 *
 *
 * [FUNCTIONS]
 * displayPrice() @ Tools.php
 * getBrightness() @ Tools.php
 * encrypt() @ Tools.php
 */


class send2friendPrestashopNewCompatibility extends send2friend {
    public static function displayPrice($price, $currency_to = false) {
        if (!defined('_PS_PRICE_DISPLAY_PRECISION_')) {
            define('_PS_PRICE_DISPLAY_PRECISION_', Context::getContext()->getComputingPrecision());
        }
        if (parent::psversion(0) >= 9)
        {
            $context = Context::getContext();
            $locale = Tools::getContextLocale($context);
            if (is_int($currency_to)) {
                $currency_to = new Currency($currency_to);
            } elseif (is_object($currency_to)) {
                $currency_to = $currency_to;
            } elseif (is_array($currency_to)) {
                $currency_to = new Currency($currency_to['id_currency']);
            }
            $currency_to = (!is_object($currency_to) ? $context->currency->iso_code:$currency_to->iso_code);
            return $locale->formatPrice($price, $currency_to);
        } else {
            return Tools::displayPrice($price, $currency_to);
        }
    }

    public static function getBrightness($hex)
    {
        if (Tools::strtolower($hex) == 'transparent') {
            return '129';
        }

        $hex = str_replace('#', '', $hex);

        if (Tools::strlen($hex) == 3) {
            $hex = $hex[0] . $hex[0] . $hex[1] . $hex[1] . $hex[2] . $hex[2];
        }

        $r = hexdec(substr($hex, 0, 2));
        $g = hexdec(substr($hex, 2, 2));
        $b = hexdec(substr($hex, 4, 2));

        return (($r * 299) + ($g * 587) + ($b * 114)) / 1000;
    }

    public static function encrypt($passwd)
    {
        return Tools::hash($passwd);
    }
}